<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for realmQualifierType StructType
 * @subpackage Structs
 */
class RealmQualifierType extends AbstractStructBase
{
    /**
     * The typeIdentifier
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $typeIdentifier;
    /**
     * The qualifier
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $qualifier;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $name;
    /**
     * Constructor method for realmQualifierType
     * @uses RealmQualifierType::setTypeIdentifier()
     * @uses RealmQualifierType::setQualifier()
     * @uses RealmQualifierType::setName()
     * @param string $typeIdentifier
     * @param string $qualifier
     * @param string $name
     */
    public function __construct($typeIdentifier = null, $qualifier = null, $name = null)
    {
        $this
            ->setTypeIdentifier($typeIdentifier)
            ->setQualifier($qualifier)
            ->setName($name);
    }
    /**
     * Get typeIdentifier value
     * @return string|null
     */
    public function getTypeIdentifier()
    {
        return $this->typeIdentifier;
    }
    /**
     * Set typeIdentifier value
     * @param string $typeIdentifier
     * @return \StructType\RealmQualifierType
     */
    public function setTypeIdentifier($typeIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($typeIdentifier) && strlen($typeIdentifier) > 32) || (is_array($typeIdentifier) && count($typeIdentifier) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($typeIdentifier) ? strlen($typeIdentifier) : count($typeIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($typeIdentifier) && !is_string($typeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeIdentifier)), __LINE__);
        }
        $this->typeIdentifier = $typeIdentifier;
        return $this;
    }
    /**
     * Get qualifier value
     * @return string|null
     */
    public function getQualifier()
    {
        return $this->qualifier;
    }
    /**
     * Set qualifier value
     * @param string $qualifier
     * @return \StructType\RealmQualifierType
     */
    public function setQualifier($qualifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($qualifier) && strlen($qualifier) > 32) || (is_array($qualifier) && count($qualifier) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($qualifier) ? strlen($qualifier) : count($qualifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($qualifier) && !is_string($qualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qualifier)), __LINE__);
        }
        $this->qualifier = $qualifier;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RealmQualifierType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RealmQualifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
