<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for queryNniNameType StructType
 * @subpackage Structs
 */
class QueryNniNameType extends AbstractStructBase
{
    /**
     * The proposedName
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $proposedName;
    /**
     * The companyNameAvailabilityCheck
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $companyNameAvailabilityCheck;
    /**
     * The bnNameAvailabilityCheck
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $bnNameAvailabilityCheck;
    /**
     * The proprietor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proprietor
     */
    public $proprietor;
    /**
     * Constructor method for queryNniNameType
     * @uses QueryNniNameType::setProposedName()
     * @uses QueryNniNameType::setCompanyNameAvailabilityCheck()
     * @uses QueryNniNameType::setBnNameAvailabilityCheck()
     * @uses QueryNniNameType::setProprietor()
     * @param string $proposedName
     * @param bool $companyNameAvailabilityCheck
     * @param bool $bnNameAvailabilityCheck
     * @param \StructType\Proprietor $proprietor
     */
    public function __construct($proposedName = null, $companyNameAvailabilityCheck = null, $bnNameAvailabilityCheck = null, \StructType\Proprietor $proprietor = null)
    {
        $this
            ->setProposedName($proposedName)
            ->setCompanyNameAvailabilityCheck($companyNameAvailabilityCheck)
            ->setBnNameAvailabilityCheck($bnNameAvailabilityCheck)
            ->setProprietor($proprietor);
    }
    /**
     * Get proposedName value
     * @return string|null
     */
    public function getProposedName()
    {
        return $this->proposedName;
    }
    /**
     * Set proposedName value
     * @param string $proposedName
     * @return \StructType\QueryNniNameType
     */
    public function setProposedName($proposedName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($proposedName) && strlen($proposedName) > 200) || (is_array($proposedName) && count($proposedName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($proposedName) ? strlen($proposedName) : count($proposedName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($proposedName) && !is_string($proposedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proposedName)), __LINE__);
        }
        $this->proposedName = $proposedName;
        return $this;
    }
    /**
     * Get companyNameAvailabilityCheck value
     * @return bool|null
     */
    public function getCompanyNameAvailabilityCheck()
    {
        return $this->companyNameAvailabilityCheck;
    }
    /**
     * Set companyNameAvailabilityCheck value
     * @param bool $companyNameAvailabilityCheck
     * @return \StructType\QueryNniNameType
     */
    public function setCompanyNameAvailabilityCheck($companyNameAvailabilityCheck = null)
    {
        // validation for constraint: pattern
        if (is_scalar($companyNameAvailabilityCheck) && !preg_match('/true/', $companyNameAvailabilityCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($companyNameAvailabilityCheck, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($companyNameAvailabilityCheck) && !is_bool($companyNameAvailabilityCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($companyNameAvailabilityCheck)), __LINE__);
        }
        $this->companyNameAvailabilityCheck = $companyNameAvailabilityCheck;
        return $this;
    }
    /**
     * Get bnNameAvailabilityCheck value
     * @return bool|null
     */
    public function getBnNameAvailabilityCheck()
    {
        return $this->bnNameAvailabilityCheck;
    }
    /**
     * Set bnNameAvailabilityCheck value
     * @param bool $bnNameAvailabilityCheck
     * @return \StructType\QueryNniNameType
     */
    public function setBnNameAvailabilityCheck($bnNameAvailabilityCheck = null)
    {
        // validation for constraint: pattern
        if (is_scalar($bnNameAvailabilityCheck) && !preg_match('/true/', $bnNameAvailabilityCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($bnNameAvailabilityCheck, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($bnNameAvailabilityCheck) && !is_bool($bnNameAvailabilityCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bnNameAvailabilityCheck)), __LINE__);
        }
        $this->bnNameAvailabilityCheck = $bnNameAvailabilityCheck;
        return $this;
    }
    /**
     * Get proprietor value
     * @return \StructType\Proprietor|null
     */
    public function getProprietor()
    {
        return $this->proprietor;
    }
    /**
     * Set proprietor value
     * @param \StructType\Proprietor $proprietor
     * @return \StructType\QueryNniNameType
     */
    public function setProprietor(\StructType\Proprietor $proprietor = null)
    {
        $this->proprietor = $proprietor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryNniNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
