<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for proprietor StructType
 * @subpackage Structs
 */
class Proprietor extends AbstractStructBase
{
    /**
     * The proprietorAcn
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $proprietorAcn;
    /**
     * The proprietorAbn
     * Meta informations extracted from the WSDL
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $proprietorAbn;
    /**
     * Constructor method for proprietor
     * @uses Proprietor::setProprietorAcn()
     * @uses Proprietor::setProprietorAbn()
     * @param int $proprietorAcn
     * @param string $proprietorAbn
     */
    public function __construct($proprietorAcn = null, $proprietorAbn = null)
    {
        $this
            ->setProprietorAcn($proprietorAcn)
            ->setProprietorAbn($proprietorAbn);
    }
    /**
     * Get proprietorAcn value
     * @return int|null
     */
    public function getProprietorAcn()
    {
        return $this->proprietorAcn;
    }
    /**
     * Set proprietorAcn value
     * @param int $proprietorAcn
     * @return \StructType\Proprietor
     */
    public function setProprietorAcn($proprietorAcn = null)
    {
        // validation for constraint: maxInclusive
        if ($proprietorAcn > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $proprietorAcn), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($proprietorAcn < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $proprietorAcn), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($proprietorAcn) && !is_numeric($proprietorAcn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($proprietorAcn)), __LINE__);
        }
        $this->proprietorAcn = $proprietorAcn;
        return $this;
    }
    /**
     * Get proprietorAbn value
     * @return string|null
     */
    public function getProprietorAbn()
    {
        return $this->proprietorAbn;
    }
    /**
     * Set proprietorAbn value
     * @param string $proprietorAbn
     * @return \StructType\Proprietor
     */
    public function setProprietorAbn($proprietorAbn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($proprietorAbn) && strlen($proprietorAbn) > 11) || (is_array($proprietorAbn) && count($proprietorAbn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($proprietorAbn) ? strlen($proprietorAbn) : count($proprietorAbn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($proprietorAbn) && strlen($proprietorAbn) < 11) || (is_array($proprietorAbn) && count($proprietorAbn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($proprietorAbn) && !preg_match('/([0-9]{11})/', $proprietorAbn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($proprietorAbn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($proprietorAbn) && !is_string($proprietorAbn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proprietorAbn)), __LINE__);
        }
        $this->proprietorAbn = $proprietorAbn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Proprietor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
