<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for priceType StructType
 * @subpackage Structs
 */
class PriceType extends AbstractStructBase
{
    /**
     * The fee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\FeeWithAmountType[]
     */
    public $fee;
    /**
     * The totalAmount
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $totalAmount;
    /**
     * Constructor method for priceType
     * @uses PriceType::setFee()
     * @uses PriceType::setTotalAmount()
     * @param \StructType\FeeWithAmountType[] $fee
     * @param float $totalAmount
     */
    public function __construct(array $fee = array(), $totalAmount = null)
    {
        $this
            ->setFee($fee)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get fee value
     * @return \StructType\FeeWithAmountType[]|null
     */
    public function getFee()
    {
        return $this->fee;
    }
    /**
     * Set fee value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeWithAmountType[] $fee
     * @return \StructType\PriceType
     */
    public function setFee(array $fee = array())
    {
        foreach ($fee as $priceTypeFeeItem) {
            // validation for constraint: itemType
            if (!$priceTypeFeeItem instanceof \StructType\FeeWithAmountType) {
                throw new \InvalidArgumentException(sprintf('The fee property can only contain items of \StructType\FeeWithAmountType, "%s" given', is_object($priceTypeFeeItem) ? get_class($priceTypeFeeItem) : gettype($priceTypeFeeItem)), __LINE__);
            }
        }
        $this->fee = $fee;
        return $this;
    }
    /**
     * Add item to fee value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeWithAmountType $item
     * @return \StructType\PriceType
     */
    public function addToFee(\StructType\FeeWithAmountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeeWithAmountType) {
            throw new \InvalidArgumentException(sprintf('The fee property can only contain items of \StructType\FeeWithAmountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->fee[] = $item;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\PriceType
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($totalAmount) && strlen(substr($totalAmount, strpos($totalAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($totalAmount, strpos($totalAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($totalAmount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $totalAmount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($totalAmount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $totalAmount), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
