<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for previousStateTerritoryType StructType
 * @subpackage Structs
 */
class PreviousStateTerritoryType extends AbstractStructBase
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $number;
    /**
     * The stateTerritoryCode
     * @var string
     */
    public $stateTerritoryCode;
    /**
     * Constructor method for previousStateTerritoryType
     * @uses PreviousStateTerritoryType::setNumber()
     * @uses PreviousStateTerritoryType::setStateTerritoryCode()
     * @param string $number
     * @param string $stateTerritoryCode
     */
    public function __construct($number = null, $stateTerritoryCode = null)
    {
        $this
            ->setNumber($number)
            ->setStateTerritoryCode($stateTerritoryCode);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\PreviousStateTerritoryType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($number) && strlen($number) > 20) || (is_array($number) && count($number) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($number) ? strlen($number) : count($number)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($number) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($number, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get stateTerritoryCode value
     * @return string|null
     */
    public function getStateTerritoryCode()
    {
        return $this->stateTerritoryCode;
    }
    /**
     * Set stateTerritoryCode value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stateTerritoryCode
     * @return \StructType\PreviousStateTerritoryType
     */
    public function setStateTerritoryCode($stateTerritoryCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($stateTerritoryCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stateTerritoryCode, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->stateTerritoryCode = $stateTerritoryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PreviousStateTerritoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
