<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for postBillpay StructType
 * @subpackage Structs
 */
class PostBillpay extends AbstractStructBase
{
    /**
     * The billpayCode
     * Meta informations extracted from the WSDL
     * - maxLength: 10
     * @var string
     */
    public $billpayCode;
    /**
     * The ref
     * Meta informations extracted from the WSDL
     * - maxLength: 18
     * @var string
     */
    public $ref;
    /**
     * Constructor method for postBillpay
     * @uses PostBillpay::setBillpayCode()
     * @uses PostBillpay::setRef()
     * @param string $billpayCode
     * @param string $ref
     */
    public function __construct($billpayCode = null, $ref = null)
    {
        $this
            ->setBillpayCode($billpayCode)
            ->setRef($ref);
    }
    /**
     * Get billpayCode value
     * @return string|null
     */
    public function getBillpayCode()
    {
        return $this->billpayCode;
    }
    /**
     * Set billpayCode value
     * @param string $billpayCode
     * @return \StructType\PostBillpay
     */
    public function setBillpayCode($billpayCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($billpayCode) && strlen($billpayCode) > 10) || (is_array($billpayCode) && count($billpayCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($billpayCode) ? strlen($billpayCode) : count($billpayCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($billpayCode) && !is_string($billpayCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billpayCode)), __LINE__);
        }
        $this->billpayCode = $billpayCode;
        return $this;
    }
    /**
     * Get ref value
     * @return string|null
     */
    public function getRef()
    {
        return $this->ref;
    }
    /**
     * Set ref value
     * @param string $ref
     * @return \StructType\PostBillpay
     */
    public function setRef($ref = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ref) && strlen($ref) > 18) || (is_array($ref) && count($ref) > 18)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 18 element(s) or a scalar of 18 character(s) at most, "%d" length given', is_scalar($ref) ? strlen($ref) : count($ref)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ref)), __LINE__);
        }
        $this->ref = $ref;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostBillpay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
