<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personsWithRolesType StructType
 * @subpackage Structs
 */
class PersonsWithRolesType extends AbstractStructBase
{
    /**
     * The person
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PersonWithRolesType[]
     */
    public $person;
    /**
     * Constructor method for personsWithRolesType
     * @uses PersonsWithRolesType::setPerson()
     * @param \StructType\PersonWithRolesType[] $person
     */
    public function __construct(array $person = array())
    {
        $this
            ->setPerson($person);
    }
    /**
     * Get person value
     * @return \StructType\PersonWithRolesType[]|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonWithRolesType[] $person
     * @return \StructType\PersonsWithRolesType
     */
    public function setPerson(array $person = array())
    {
        foreach ($person as $personsWithRolesTypePersonItem) {
            // validation for constraint: itemType
            if (!$personsWithRolesTypePersonItem instanceof \StructType\PersonWithRolesType) {
                throw new \InvalidArgumentException(sprintf('The person property can only contain items of \StructType\PersonWithRolesType, "%s" given', is_object($personsWithRolesTypePersonItem) ? get_class($personsWithRolesTypePersonItem) : gettype($personsWithRolesTypePersonItem)), __LINE__);
            }
        }
        $this->person = $person;
        return $this;
    }
    /**
     * Add item to person value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonWithRolesType $item
     * @return \StructType\PersonsWithRolesType
     */
    public function addToPerson(\StructType\PersonWithRolesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonWithRolesType) {
            throw new \InvalidArgumentException(sprintf('The person property can only contain items of \StructType\PersonWithRolesType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->person[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonsWithRolesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
