<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personNameWithRoleType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Personal name
 * @subpackage Structs
 */
class PersonNameWithRoleType extends PersonNameType
{
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 5
     * - minLength: 3
     * @var string
     */
    public $role;
    /**
     * Constructor method for personNameWithRoleType
     * @uses PersonNameWithRoleType::setRole()
     * @param string $role
     */
    public function __construct($role = null)
    {
        $this
            ->setRole($role);
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\PersonNameWithRoleType
     */
    public function setRole($role = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($role) && strlen($role) > 5) || (is_array($role) && count($role) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($role) ? strlen($role) : count($role)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($role) && strlen($role) < 3) || (is_array($role) && count($role) < 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonNameWithRoleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
