<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personExtractRequestType StructType
 * @subpackage Structs
 */
class PersonExtractRequestType extends AbstractStructBase
{
    /**
     * The searchId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Internal Ascot Ids ie N9
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $searchId;
    /**
     * The personIds
     * @var \StructType\PersonIds
     */
    public $personIds;
    /**
     * The showHistory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $showHistory;
    /**
     * Constructor method for personExtractRequestType
     * @uses PersonExtractRequestType::setSearchId()
     * @uses PersonExtractRequestType::setPersonIds()
     * @uses PersonExtractRequestType::setShowHistory()
     * @param int $searchId
     * @param \StructType\PersonIds $personIds
     * @param bool $showHistory
     */
    public function __construct($searchId = null, \StructType\PersonIds $personIds = null, $showHistory = null)
    {
        $this
            ->setSearchId($searchId)
            ->setPersonIds($personIds)
            ->setShowHistory($showHistory);
    }
    /**
     * Get searchId value
     * @return int|null
     */
    public function getSearchId()
    {
        return $this->searchId;
    }
    /**
     * Set searchId value
     * @param int $searchId
     * @return \StructType\PersonExtractRequestType
     */
    public function setSearchId($searchId = null)
    {
        // validation for constraint: maxInclusive
        if ($searchId > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $searchId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($searchId < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $searchId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($searchId) && !is_numeric($searchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($searchId)), __LINE__);
        }
        $this->searchId = $searchId;
        return $this;
    }
    /**
     * Get personIds value
     * @return \StructType\PersonIds|null
     */
    public function getPersonIds()
    {
        return $this->personIds;
    }
    /**
     * Set personIds value
     * @param \StructType\PersonIds $personIds
     * @return \StructType\PersonExtractRequestType
     */
    public function setPersonIds(\StructType\PersonIds $personIds = null)
    {
        $this->personIds = $personIds;
        return $this;
    }
    /**
     * Get showHistory value
     * @return bool|null
     */
    public function getShowHistory()
    {
        return $this->showHistory;
    }
    /**
     * Set showHistory value
     * @param bool $showHistory
     * @return \StructType\PersonExtractRequestType
     */
    public function setShowHistory($showHistory = null)
    {
        // validation for constraint: pattern
        if (is_scalar($showHistory) && !preg_match('/true/', $showHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($showHistory, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($showHistory) && !is_bool($showHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($showHistory)), __LINE__);
        }
        $this->showHistory = $showHistory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonExtractRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
