<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for partnerAssociateType StructType
 * @subpackage Structs
 */
class PartnerAssociateType extends AbstractStructBase
{
    /**
     * The individual
     * Meta informations extracted from the WSDL
     * - documentation: Individual
     * @var \StructType\IndividualType
     */
    public $individual;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - documentation: Company
     * @var \StructType\OrganisationType
     */
    public $organisation;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $endDate;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - documentation: Change Of Details only
     * - minOccurs: 0
     * @var string
     */
    public $action;
    /**
     * Constructor method for partnerAssociateType
     * @uses PartnerAssociateType::setIndividual()
     * @uses PartnerAssociateType::setOrganisation()
     * @uses PartnerAssociateType::setStartDate()
     * @uses PartnerAssociateType::setEndDate()
     * @uses PartnerAssociateType::setAction()
     * @param \StructType\IndividualType $individual
     * @param \StructType\OrganisationType $organisation
     * @param string $startDate
     * @param string $endDate
     * @param string $action
     */
    public function __construct(\StructType\IndividualType $individual = null, \StructType\OrganisationType $organisation = null, $startDate = null, $endDate = null, $action = null)
    {
        $this
            ->setIndividual($individual)
            ->setOrganisation($organisation)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAction($action);
    }
    /**
     * Get individual value
     * @return \StructType\IndividualType|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\IndividualType $individual
     * @return \StructType\PartnerAssociateType
     */
    public function setIndividual(\StructType\IndividualType $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\OrganisationType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\OrganisationType $organisation
     * @return \StructType\PartnerAssociateType
     */
    public function setOrganisation(\StructType\OrganisationType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\PartnerAssociateType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: minInclusive
        if ($startDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\PartnerAssociateType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: minInclusive
        if ($endDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @uses \EnumType\UpdateActionType::valueIsValid()
     * @uses \EnumType\UpdateActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\PartnerAssociateType
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UpdateActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\UpdateActionType::getValidValues())), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerAssociateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
