<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for outboundItemIdentifierType StructType
 * @subpackage Structs
 */
class OutboundItemIdentifierType extends AbstractStructBase
{
    /**
     * The referenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 99999999999
     * - minInclusive: 1
     * @var int
     */
    public $referenceNumber;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Ascot document number
     * - maxLength: 9
     * - minLength: 1
     * - pattern: [A-Z0-9\.]*
     * @var string
     */
    public $documentNumber;
    /**
     * The externalReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Client provided to be unique within accountIdentifier
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $externalReferenceNumber;
    /**
     * The inboxNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 99999999999
     * - minInclusive: 1
     * @var int
     */
    public $inboxNumber;
    /**
     * Constructor method for outboundItemIdentifierType
     * @uses OutboundItemIdentifierType::setReferenceNumber()
     * @uses OutboundItemIdentifierType::setDocumentNumber()
     * @uses OutboundItemIdentifierType::setExternalReferenceNumber()
     * @uses OutboundItemIdentifierType::setInboxNumber()
     * @param int $referenceNumber
     * @param string $documentNumber
     * @param string $externalReferenceNumber
     * @param int $inboxNumber
     */
    public function __construct($referenceNumber = null, $documentNumber = null, $externalReferenceNumber = null, $inboxNumber = null)
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setDocumentNumber($documentNumber)
            ->setExternalReferenceNumber($externalReferenceNumber)
            ->setInboxNumber($inboxNumber);
    }
    /**
     * Get referenceNumber value
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }
    /**
     * Set referenceNumber value
     * @param int $referenceNumber
     * @return \StructType\OutboundItemIdentifierType
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($referenceNumber > 99999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999999, "%s" given', $referenceNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($referenceNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $referenceNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($referenceNumber) && !is_numeric($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->referenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param string $documentNumber
     * @return \StructType\OutboundItemIdentifierType
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) > 9) || (is_array($documentNumber) && count($documentNumber) > 9)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s) at most, "%d" length given', is_scalar($documentNumber) ? strlen($documentNumber) : count($documentNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) < 1) || (is_array($documentNumber) && count($documentNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($documentNumber) && !preg_match('/[A-Z0-9\\.]*/', $documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.]*", "%s" given', var_export($documentNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get externalReferenceNumber value
     * @return string|null
     */
    public function getExternalReferenceNumber()
    {
        return $this->externalReferenceNumber;
    }
    /**
     * Set externalReferenceNumber value
     * @param string $externalReferenceNumber
     * @return \StructType\OutboundItemIdentifierType
     */
    public function setExternalReferenceNumber($externalReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalReferenceNumber) && strlen($externalReferenceNumber) > 50) || (is_array($externalReferenceNumber) && count($externalReferenceNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($externalReferenceNumber) ? strlen($externalReferenceNumber) : count($externalReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalReferenceNumber) && strlen($externalReferenceNumber) < 1) || (is_array($externalReferenceNumber) && count($externalReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalReferenceNumber) && !is_string($externalReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalReferenceNumber)), __LINE__);
        }
        $this->externalReferenceNumber = $externalReferenceNumber;
        return $this;
    }
    /**
     * Get inboxNumber value
     * @return int|null
     */
    public function getInboxNumber()
    {
        return $this->inboxNumber;
    }
    /**
     * Set inboxNumber value
     * @param int $inboxNumber
     * @return \StructType\OutboundItemIdentifierType
     */
    public function setInboxNumber($inboxNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($inboxNumber > 99999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999999, "%s" given', $inboxNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($inboxNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $inboxNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($inboxNumber) && !is_numeric($inboxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inboxNumber)), __LINE__);
        }
        $this->inboxNumber = $inboxNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutboundItemIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
