<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for outboundBusinessNameType StructType
 * @subpackage Structs
 */
class OutboundBusinessNameType extends AbstractStructBase
{
    /**
     * The nniNumber
     * @var string
     */
    public $nniNumber;
    /**
     * The bnReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $bnReferenceNumber;
    /**
     * The name
     * @var \StructType\DistinguishedNameExtType
     */
    public $name;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\IntervalStatusType[]
     */
    public $status;
    /**
     * The term
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $term;
    /**
     * The previousStateOrTerritory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PreviousStateTerritoryType
     */
    public $previousStateOrTerritory;
    /**
     * The jurisdiction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 80
     * @var string
     */
    public $jurisdiction;
    /**
     * The dateRegistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRegistered;
    /**
     * The dateRenewal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRenewal;
    /**
     * The dateDeregistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateDeregistered;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AddressExtType[]
     */
    public $address;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: email address
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * The smsNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $smsNumber;
    /**
     * The representative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\RepresentativeType[]
     */
    public $representative;
    /**
     * Constructor method for outboundBusinessNameType
     * @uses OutboundBusinessNameType::setNniNumber()
     * @uses OutboundBusinessNameType::setBnReferenceNumber()
     * @uses OutboundBusinessNameType::setName()
     * @uses OutboundBusinessNameType::setStatus()
     * @uses OutboundBusinessNameType::setTerm()
     * @uses OutboundBusinessNameType::setPreviousStateOrTerritory()
     * @uses OutboundBusinessNameType::setJurisdiction()
     * @uses OutboundBusinessNameType::setDateRegistered()
     * @uses OutboundBusinessNameType::setDateRenewal()
     * @uses OutboundBusinessNameType::setDateDeregistered()
     * @uses OutboundBusinessNameType::setAddress()
     * @uses OutboundBusinessNameType::setEmailAddress()
     * @uses OutboundBusinessNameType::setSmsNumber()
     * @uses OutboundBusinessNameType::setRepresentative()
     * @param string $nniNumber
     * @param string $bnReferenceNumber
     * @param \StructType\DistinguishedNameExtType $name
     * @param \StructType\IntervalStatusType[] $status
     * @param string $term
     * @param \StructType\PreviousStateTerritoryType $previousStateOrTerritory
     * @param string $jurisdiction
     * @param string $dateRegistered
     * @param string $dateRenewal
     * @param string $dateDeregistered
     * @param \StructType\AddressExtType[] $address
     * @param string $emailAddress
     * @param string $smsNumber
     * @param \StructType\RepresentativeType[] $representative
     */
    public function __construct($nniNumber = null, $bnReferenceNumber = null, \StructType\DistinguishedNameExtType $name = null, array $status = array(), $term = null, \StructType\PreviousStateTerritoryType $previousStateOrTerritory = null, $jurisdiction = null, $dateRegistered = null, $dateRenewal = null, $dateDeregistered = null, array $address = array(), $emailAddress = null, $smsNumber = null, array $representative = array())
    {
        $this
            ->setNniNumber($nniNumber)
            ->setBnReferenceNumber($bnReferenceNumber)
            ->setName($name)
            ->setStatus($status)
            ->setTerm($term)
            ->setPreviousStateOrTerritory($previousStateOrTerritory)
            ->setJurisdiction($jurisdiction)
            ->setDateRegistered($dateRegistered)
            ->setDateRenewal($dateRenewal)
            ->setDateDeregistered($dateDeregistered)
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setSmsNumber($smsNumber)
            ->setRepresentative($representative);
    }
    /**
     * Get nniNumber value
     * @return string|null
     */
    public function getNniNumber()
    {
        return $this->nniNumber;
    }
    /**
     * Set nniNumber value
     * @param string $nniNumber
     * @return \StructType\OutboundBusinessNameType
     */
    public function setNniNumber($nniNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nniNumber) && !is_string($nniNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nniNumber)), __LINE__);
        }
        $this->nniNumber = $nniNumber;
        return $this;
    }
    /**
     * Get bnReferenceNumber value
     * @return string|null
     */
    public function getBnReferenceNumber()
    {
        return $this->bnReferenceNumber;
    }
    /**
     * Set bnReferenceNumber value
     * @param string $bnReferenceNumber
     * @return \StructType\OutboundBusinessNameType
     */
    public function setBnReferenceNumber($bnReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) > 20) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($bnReferenceNumber) ? strlen($bnReferenceNumber) : count($bnReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) < 1) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bnReferenceNumber) && !is_string($bnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bnReferenceNumber)), __LINE__);
        }
        $this->bnReferenceNumber = $bnReferenceNumber;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\DistinguishedNameExtType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\DistinguishedNameExtType $name
     * @return \StructType\OutboundBusinessNameType
     */
    public function setName(\StructType\DistinguishedNameExtType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\IntervalStatusType[]|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @throws \InvalidArgumentException
     * @param \StructType\IntervalStatusType[] $status
     * @return \StructType\OutboundBusinessNameType
     */
    public function setStatus(array $status = array())
    {
        foreach ($status as $outboundBusinessNameTypeStatusItem) {
            // validation for constraint: itemType
            if (!$outboundBusinessNameTypeStatusItem instanceof \StructType\IntervalStatusType) {
                throw new \InvalidArgumentException(sprintf('The status property can only contain items of \StructType\IntervalStatusType, "%s" given', is_object($outboundBusinessNameTypeStatusItem) ? get_class($outboundBusinessNameTypeStatusItem) : gettype($outboundBusinessNameTypeStatusItem)), __LINE__);
            }
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Add item to status value
     * @throws \InvalidArgumentException
     * @param \StructType\IntervalStatusType $item
     * @return \StructType\OutboundBusinessNameType
     */
    public function addToStatus(\StructType\IntervalStatusType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IntervalStatusType) {
            throw new \InvalidArgumentException(sprintf('The status property can only contain items of \StructType\IntervalStatusType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->status[] = $item;
        return $this;
    }
    /**
     * Get term value
     * @return string|null
     */
    public function getTerm()
    {
        return $this->term;
    }
    /**
     * Set term value
     * @uses \EnumType\TermType::valueIsValid()
     * @uses \EnumType\TermType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $term
     * @return \StructType\OutboundBusinessNameType
     */
    public function setTerm($term = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TermType::valueIsValid($term)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $term, implode(', ', \EnumType\TermType::getValidValues())), __LINE__);
        }
        $this->term = $term;
        return $this;
    }
    /**
     * Get previousStateOrTerritory value
     * @return \StructType\PreviousStateTerritoryType|null
     */
    public function getPreviousStateOrTerritory()
    {
        return $this->previousStateOrTerritory;
    }
    /**
     * Set previousStateOrTerritory value
     * @param \StructType\PreviousStateTerritoryType $previousStateOrTerritory
     * @return \StructType\OutboundBusinessNameType
     */
    public function setPreviousStateOrTerritory(\StructType\PreviousStateTerritoryType $previousStateOrTerritory = null)
    {
        $this->previousStateOrTerritory = $previousStateOrTerritory;
        return $this;
    }
    /**
     * Get jurisdiction value
     * @return string|null
     */
    public function getJurisdiction()
    {
        return $this->jurisdiction;
    }
    /**
     * Set jurisdiction value
     * @param string $jurisdiction
     * @return \StructType\OutboundBusinessNameType
     */
    public function setJurisdiction($jurisdiction = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($jurisdiction) && strlen($jurisdiction) > 80) || (is_array($jurisdiction) && count($jurisdiction) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($jurisdiction) ? strlen($jurisdiction) : count($jurisdiction)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($jurisdiction) && !is_string($jurisdiction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurisdiction)), __LINE__);
        }
        $this->jurisdiction = $jurisdiction;
        return $this;
    }
    /**
     * Get dateRegistered value
     * @return string|null
     */
    public function getDateRegistered()
    {
        return $this->dateRegistered;
    }
    /**
     * Set dateRegistered value
     * @param string $dateRegistered
     * @return \StructType\OutboundBusinessNameType
     */
    public function setDateRegistered($dateRegistered = null)
    {
        // validation for constraint: minInclusive
        if ($dateRegistered < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRegistered), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRegistered) && !is_string($dateRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRegistered)), __LINE__);
        }
        $this->dateRegistered = $dateRegistered;
        return $this;
    }
    /**
     * Get dateRenewal value
     * @return string|null
     */
    public function getDateRenewal()
    {
        return $this->dateRenewal;
    }
    /**
     * Set dateRenewal value
     * @param string $dateRenewal
     * @return \StructType\OutboundBusinessNameType
     */
    public function setDateRenewal($dateRenewal = null)
    {
        // validation for constraint: minInclusive
        if ($dateRenewal < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRenewal), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRenewal) && !is_string($dateRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRenewal)), __LINE__);
        }
        $this->dateRenewal = $dateRenewal;
        return $this;
    }
    /**
     * Get dateDeregistered value
     * @return string|null
     */
    public function getDateDeregistered()
    {
        return $this->dateDeregistered;
    }
    /**
     * Set dateDeregistered value
     * @param string $dateDeregistered
     * @return \StructType\OutboundBusinessNameType
     */
    public function setDateDeregistered($dateDeregistered = null)
    {
        // validation for constraint: minInclusive
        if ($dateDeregistered < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateDeregistered), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDeregistered) && !is_string($dateDeregistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDeregistered)), __LINE__);
        }
        $this->dateDeregistered = $dateDeregistered;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\AddressExtType[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressExtType[] $address
     * @return \StructType\OutboundBusinessNameType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $outboundBusinessNameTypeAddressItem) {
            // validation for constraint: itemType
            if (!$outboundBusinessNameTypeAddressItem instanceof \StructType\AddressExtType) {
                throw new \InvalidArgumentException(sprintf('The address property can only contain items of \StructType\AddressExtType, "%s" given', is_object($outboundBusinessNameTypeAddressItem) ? get_class($outboundBusinessNameTypeAddressItem) : gettype($outboundBusinessNameTypeAddressItem)), __LINE__);
            }
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressExtType $item
     * @return \StructType\OutboundBusinessNameType
     */
    public function addToAddress(\StructType\AddressExtType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressExtType) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of \StructType\AddressExtType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \StructType\OutboundBusinessNameType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get smsNumber value
     * @return string|null
     */
    public function getSmsNumber()
    {
        return $this->smsNumber;
    }
    /**
     * Set smsNumber value
     * @param string $smsNumber
     * @return \StructType\OutboundBusinessNameType
     */
    public function setSmsNumber($smsNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($smsNumber) && strlen($smsNumber) > 15) || (is_array($smsNumber) && count($smsNumber) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($smsNumber) ? strlen($smsNumber) : count($smsNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($smsNumber) && !is_string($smsNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smsNumber)), __LINE__);
        }
        $this->smsNumber = $smsNumber;
        return $this;
    }
    /**
     * Get representative value
     * @return \StructType\RepresentativeType[]|null
     */
    public function getRepresentative()
    {
        return $this->representative;
    }
    /**
     * Set representative value
     * @throws \InvalidArgumentException
     * @param \StructType\RepresentativeType[] $representative
     * @return \StructType\OutboundBusinessNameType
     */
    public function setRepresentative(array $representative = array())
    {
        foreach ($representative as $outboundBusinessNameTypeRepresentativeItem) {
            // validation for constraint: itemType
            if (!$outboundBusinessNameTypeRepresentativeItem instanceof \StructType\RepresentativeType) {
                throw new \InvalidArgumentException(sprintf('The representative property can only contain items of \StructType\RepresentativeType, "%s" given', is_object($outboundBusinessNameTypeRepresentativeItem) ? get_class($outboundBusinessNameTypeRepresentativeItem) : gettype($outboundBusinessNameTypeRepresentativeItem)), __LINE__);
            }
        }
        $this->representative = $representative;
        return $this;
    }
    /**
     * Add item to representative value
     * @throws \InvalidArgumentException
     * @param \StructType\RepresentativeType $item
     * @return \StructType\OutboundBusinessNameType
     */
    public function addToRepresentative(\StructType\RepresentativeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RepresentativeType) {
            throw new \InvalidArgumentException(sprintf('The representative property can only contain items of \StructType\RepresentativeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->representative[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutboundBusinessNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
