<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for organisationNamePlusIdType StructType
 * @subpackage Structs
 */
class OrganisationNamePlusIdType extends AbstractStructBase
{
    /**
     * The identifier
     * @var \StructType\OrganisationIdentifierType
     */
    public $identifier;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $name;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * Constructor method for organisationNamePlusIdType
     * @uses OrganisationNamePlusIdType::setIdentifier()
     * @uses OrganisationNamePlusIdType::setName()
     * @uses OrganisationNamePlusIdType::setType()
     * @param \StructType\OrganisationIdentifierType $identifier
     * @param string $name
     * @param string $type
     */
    public function __construct(\StructType\OrganisationIdentifierType $identifier = null, $name = null, $type = null)
    {
        $this
            ->setIdentifier($identifier)
            ->setName($name)
            ->setType($type);
    }
    /**
     * Get identifier value
     * @return \StructType\OrganisationIdentifierType|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param \StructType\OrganisationIdentifierType $identifier
     * @return \StructType\OrganisationNamePlusIdType
     */
    public function setIdentifier(\StructType\OrganisationIdentifierType $identifier = null)
    {
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\OrganisationNamePlusIdType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\OrganisationNamePlusIdType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrganisationNamePlusIdType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
