<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for organisationIdentifierType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Generic type for ABN, ACN, ARBN, ARSN, BNN
 * @subpackage Structs
 */
class OrganisationIdentifierType extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - documentation: ACN/ARBN/ARSN
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $value;
    /**
     * Constructor method for organisationIdentifierType
     * @uses OrganisationIdentifierType::setType()
     * @uses OrganisationIdentifierType::setValue()
     * @param string $type
     * @param int $value
     */
    public function __construct($type = null, $value = null)
    {
        $this
            ->setType($type)
            ->setValue($value);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\OrganisationIdentifierType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get value value
     * @return int|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param int $value
     * @return \StructType\OrganisationIdentifierType
     */
    public function setValue($value = null)
    {
        // validation for constraint: maxInclusive
        if ($value > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $value), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($value < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $value), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($value) && !is_numeric($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrganisationIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
