<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for officeholders StructType
 * @subpackage Structs
 */
class Officeholders extends AbstractStructBase
{
    /**
     * The officeholder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OfficeholderType[]
     */
    public $officeholder;
    /**
     * Constructor method for officeholders
     * @uses Officeholders::setOfficeholder()
     * @param \StructType\OfficeholderType[] $officeholder
     */
    public function __construct(array $officeholder = array())
    {
        $this
            ->setOfficeholder($officeholder);
    }
    /**
     * Get officeholder value
     * @return \StructType\OfficeholderType[]|null
     */
    public function getOfficeholder()
    {
        return $this->officeholder;
    }
    /**
     * Set officeholder value
     * @throws \InvalidArgumentException
     * @param \StructType\OfficeholderType[] $officeholder
     * @return \StructType\Officeholders
     */
    public function setOfficeholder(array $officeholder = array())
    {
        foreach ($officeholder as $officeholdersOfficeholderItem) {
            // validation for constraint: itemType
            if (!$officeholdersOfficeholderItem instanceof \StructType\OfficeholderType) {
                throw new \InvalidArgumentException(sprintf('The officeholder property can only contain items of \StructType\OfficeholderType, "%s" given', is_object($officeholdersOfficeholderItem) ? get_class($officeholdersOfficeholderItem) : gettype($officeholdersOfficeholderItem)), __LINE__);
            }
        }
        $this->officeholder = $officeholder;
        return $this;
    }
    /**
     * Add item to officeholder value
     * @throws \InvalidArgumentException
     * @param \StructType\OfficeholderType $item
     * @return \StructType\Officeholders
     */
    public function addToOfficeholder(\StructType\OfficeholderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfficeholderType) {
            throw new \InvalidArgumentException(sprintf('The officeholder property can only contain items of \StructType\OfficeholderType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->officeholder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Officeholders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
