<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nniEntityType StructType
 * @subpackage Structs
 */
class NniEntityType extends AbstractStructBase
{
    /**
     * The businessEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AbrEntityType
     */
    public $businessEntity;
    /**
     * The identifier
     * @var \StructType\IdentifierType
     */
    public $identifier;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $name;
    /**
     * The type
     * @var \StructType\NniTypeType
     */
    public $type;
    /**
     * The status
     * @var \StructType\StatusType
     */
    public $status;
    /**
     * The previousStateTerritory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PreviousStateTerritoryType
     */
    public $previousStateTerritory;
    /**
     * The dateRegistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRegistered;
    /**
     * The dateDeregistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateDeregistered;
    /**
     * The dateRenewal
     * Meta informations extracted from the WSDL
     * - documentation: for Business Names
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRenewal;
    /**
     * The dateReview
     * Meta informations extracted from the WSDL
     * - documentation: for ASIC incorporated Bodies
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateReview;
    /**
     * The jurisdiction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 80
     * @var string
     */
    public $jurisdiction;
    /**
     * The registeredAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $registeredAddress;
    /**
     * The recentDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var \StructType\DocumentType[]
     */
    public $recentDocuments;
    /**
     * Constructor method for nniEntityType
     * @uses NniEntityType::setBusinessEntity()
     * @uses NniEntityType::setIdentifier()
     * @uses NniEntityType::setName()
     * @uses NniEntityType::setType()
     * @uses NniEntityType::setStatus()
     * @uses NniEntityType::setPreviousStateTerritory()
     * @uses NniEntityType::setDateRegistered()
     * @uses NniEntityType::setDateDeregistered()
     * @uses NniEntityType::setDateRenewal()
     * @uses NniEntityType::setDateReview()
     * @uses NniEntityType::setJurisdiction()
     * @uses NniEntityType::setRegisteredAddress()
     * @uses NniEntityType::setRecentDocuments()
     * @param \StructType\AbrEntityType $businessEntity
     * @param \StructType\IdentifierType $identifier
     * @param string $name
     * @param \StructType\NniTypeType $type
     * @param \StructType\StatusType $status
     * @param \StructType\PreviousStateTerritoryType $previousStateTerritory
     * @param string $dateRegistered
     * @param string $dateDeregistered
     * @param string $dateRenewal
     * @param string $dateReview
     * @param string $jurisdiction
     * @param string $registeredAddress
     * @param \StructType\DocumentType[] $recentDocuments
     */
    public function __construct(\StructType\AbrEntityType $businessEntity = null, \StructType\IdentifierType $identifier = null, $name = null, \StructType\NniTypeType $type = null, \StructType\StatusType $status = null, \StructType\PreviousStateTerritoryType $previousStateTerritory = null, $dateRegistered = null, $dateDeregistered = null, $dateRenewal = null, $dateReview = null, $jurisdiction = null, $registeredAddress = null, array $recentDocuments = array())
    {
        $this
            ->setBusinessEntity($businessEntity)
            ->setIdentifier($identifier)
            ->setName($name)
            ->setType($type)
            ->setStatus($status)
            ->setPreviousStateTerritory($previousStateTerritory)
            ->setDateRegistered($dateRegistered)
            ->setDateDeregistered($dateDeregistered)
            ->setDateRenewal($dateRenewal)
            ->setDateReview($dateReview)
            ->setJurisdiction($jurisdiction)
            ->setRegisteredAddress($registeredAddress)
            ->setRecentDocuments($recentDocuments);
    }
    /**
     * Get businessEntity value
     * @return \StructType\AbrEntityType|null
     */
    public function getBusinessEntity()
    {
        return $this->businessEntity;
    }
    /**
     * Set businessEntity value
     * @param \StructType\AbrEntityType $businessEntity
     * @return \StructType\NniEntityType
     */
    public function setBusinessEntity(\StructType\AbrEntityType $businessEntity = null)
    {
        $this->businessEntity = $businessEntity;
        return $this;
    }
    /**
     * Get identifier value
     * @return \StructType\IdentifierType|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param \StructType\IdentifierType $identifier
     * @return \StructType\NniEntityType
     */
    public function setIdentifier(\StructType\IdentifierType $identifier = null)
    {
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\NniEntityType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return \StructType\NniTypeType|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param \StructType\NniTypeType $type
     * @return \StructType\NniEntityType
     */
    public function setType(\StructType\NniTypeType $type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\StatusType|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\StatusType $status
     * @return \StructType\NniEntityType
     */
    public function setStatus(\StructType\StatusType $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get previousStateTerritory value
     * @return \StructType\PreviousStateTerritoryType|null
     */
    public function getPreviousStateTerritory()
    {
        return $this->previousStateTerritory;
    }
    /**
     * Set previousStateTerritory value
     * @param \StructType\PreviousStateTerritoryType $previousStateTerritory
     * @return \StructType\NniEntityType
     */
    public function setPreviousStateTerritory(\StructType\PreviousStateTerritoryType $previousStateTerritory = null)
    {
        $this->previousStateTerritory = $previousStateTerritory;
        return $this;
    }
    /**
     * Get dateRegistered value
     * @return string|null
     */
    public function getDateRegistered()
    {
        return $this->dateRegistered;
    }
    /**
     * Set dateRegistered value
     * @param string $dateRegistered
     * @return \StructType\NniEntityType
     */
    public function setDateRegistered($dateRegistered = null)
    {
        // validation for constraint: minInclusive
        if ($dateRegistered < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRegistered), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRegistered) && !is_string($dateRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRegistered)), __LINE__);
        }
        $this->dateRegistered = $dateRegistered;
        return $this;
    }
    /**
     * Get dateDeregistered value
     * @return string|null
     */
    public function getDateDeregistered()
    {
        return $this->dateDeregistered;
    }
    /**
     * Set dateDeregistered value
     * @param string $dateDeregistered
     * @return \StructType\NniEntityType
     */
    public function setDateDeregistered($dateDeregistered = null)
    {
        // validation for constraint: minInclusive
        if ($dateDeregistered < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateDeregistered), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDeregistered) && !is_string($dateDeregistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDeregistered)), __LINE__);
        }
        $this->dateDeregistered = $dateDeregistered;
        return $this;
    }
    /**
     * Get dateRenewal value
     * @return string|null
     */
    public function getDateRenewal()
    {
        return $this->dateRenewal;
    }
    /**
     * Set dateRenewal value
     * @param string $dateRenewal
     * @return \StructType\NniEntityType
     */
    public function setDateRenewal($dateRenewal = null)
    {
        // validation for constraint: minInclusive
        if ($dateRenewal < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRenewal), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRenewal) && !is_string($dateRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRenewal)), __LINE__);
        }
        $this->dateRenewal = $dateRenewal;
        return $this;
    }
    /**
     * Get dateReview value
     * @return string|null
     */
    public function getDateReview()
    {
        return $this->dateReview;
    }
    /**
     * Set dateReview value
     * @param string $dateReview
     * @return \StructType\NniEntityType
     */
    public function setDateReview($dateReview = null)
    {
        // validation for constraint: minInclusive
        if ($dateReview < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateReview), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateReview) && !is_string($dateReview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateReview)), __LINE__);
        }
        $this->dateReview = $dateReview;
        return $this;
    }
    /**
     * Get jurisdiction value
     * @return string|null
     */
    public function getJurisdiction()
    {
        return $this->jurisdiction;
    }
    /**
     * Set jurisdiction value
     * @param string $jurisdiction
     * @return \StructType\NniEntityType
     */
    public function setJurisdiction($jurisdiction = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($jurisdiction) && strlen($jurisdiction) > 80) || (is_array($jurisdiction) && count($jurisdiction) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($jurisdiction) ? strlen($jurisdiction) : count($jurisdiction)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($jurisdiction) && !is_string($jurisdiction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurisdiction)), __LINE__);
        }
        $this->jurisdiction = $jurisdiction;
        return $this;
    }
    /**
     * Get registeredAddress value
     * @return string|null
     */
    public function getRegisteredAddress()
    {
        return $this->registeredAddress;
    }
    /**
     * Set registeredAddress value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $registeredAddress
     * @return \StructType\NniEntityType
     */
    public function setRegisteredAddress($registeredAddress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($registeredAddress)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $registeredAddress, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->registeredAddress = $registeredAddress;
        return $this;
    }
    /**
     * Get recentDocuments value
     * @return \StructType\DocumentType[]|null
     */
    public function getRecentDocuments()
    {
        return $this->recentDocuments;
    }
    /**
     * Set recentDocuments value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType[] $recentDocuments
     * @return \StructType\NniEntityType
     */
    public function setRecentDocuments(array $recentDocuments = array())
    {
        foreach ($recentDocuments as $nniEntityTypeRecentDocumentsItem) {
            // validation for constraint: itemType
            if (!$nniEntityTypeRecentDocumentsItem instanceof \StructType\DocumentType) {
                throw new \InvalidArgumentException(sprintf('The recentDocuments property can only contain items of \StructType\DocumentType, "%s" given', is_object($nniEntityTypeRecentDocumentsItem) ? get_class($nniEntityTypeRecentDocumentsItem) : gettype($nniEntityTypeRecentDocumentsItem)), __LINE__);
            }
        }
        $this->recentDocuments = $recentDocuments;
        return $this;
    }
    /**
     * Add item to recentDocuments value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType $item
     * @return \StructType\NniEntityType
     */
    public function addToRecentDocuments(\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The recentDocuments property can only contain items of \StructType\DocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->recentDocuments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NniEntityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
