<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nameType StructType
 * @subpackage Structs
 */
class NameType extends AbstractStructBase
{
    /**
     * The familyName
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * - minLength: 2
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * - whiteSpace: collapse
     * @var string
     */
    public $familyName;
    /**
     * The givenName1
     * Meta informations extracted from the WSDL
     * - maxLength: 30
     * - minLength: 2
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $givenName1;
    /**
     * The givenName2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * - minLength: 2
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $givenName2;
    /**
     * The givenName3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * - minLength: 2
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $givenName3;
    /**
     * Constructor method for nameType
     * @uses NameType::setFamilyName()
     * @uses NameType::setGivenName1()
     * @uses NameType::setGivenName2()
     * @uses NameType::setGivenName3()
     * @param string $familyName
     * @param string $givenName1
     * @param string $givenName2
     * @param string $givenName3
     */
    public function __construct($familyName = null, $givenName1 = null, $givenName2 = null, $givenName3 = null)
    {
        $this
            ->setFamilyName($familyName)
            ->setGivenName1($givenName1)
            ->setGivenName2($givenName2)
            ->setGivenName3($givenName3);
    }
    /**
     * Get familyName value
     * @return string|null
     */
    public function getFamilyName()
    {
        return $this->familyName;
    }
    /**
     * Set familyName value
     * @param string $familyName
     * @return \StructType\NameType
     */
    public function setFamilyName($familyName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($familyName) && strlen($familyName) > 40) || (is_array($familyName) && count($familyName) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($familyName) ? strlen($familyName) : count($familyName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($familyName) && strlen($familyName) < 2) || (is_array($familyName) && count($familyName) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($familyName) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $familyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($familyName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($familyName) && !is_string($familyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($familyName)), __LINE__);
        }
        $this->familyName = $familyName;
        return $this;
    }
    /**
     * Get givenName1 value
     * @return string|null
     */
    public function getGivenName1()
    {
        return $this->givenName1;
    }
    /**
     * Set givenName1 value
     * @param string $givenName1
     * @return \StructType\NameType
     */
    public function setGivenName1($givenName1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($givenName1) && strlen($givenName1) > 30) || (is_array($givenName1) && count($givenName1) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($givenName1) ? strlen($givenName1) : count($givenName1)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($givenName1) && strlen($givenName1) < 2) || (is_array($givenName1) && count($givenName1) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($givenName1) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $givenName1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($givenName1, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($givenName1) && !is_string($givenName1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($givenName1)), __LINE__);
        }
        $this->givenName1 = $givenName1;
        return $this;
    }
    /**
     * Get givenName2 value
     * @return string|null
     */
    public function getGivenName2()
    {
        return $this->givenName2;
    }
    /**
     * Set givenName2 value
     * @param string $givenName2
     * @return \StructType\NameType
     */
    public function setGivenName2($givenName2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($givenName2) && strlen($givenName2) > 30) || (is_array($givenName2) && count($givenName2) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($givenName2) ? strlen($givenName2) : count($givenName2)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($givenName2) && strlen($givenName2) < 2) || (is_array($givenName2) && count($givenName2) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($givenName2) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $givenName2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($givenName2, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($givenName2) && !is_string($givenName2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($givenName2)), __LINE__);
        }
        $this->givenName2 = $givenName2;
        return $this;
    }
    /**
     * Get givenName3 value
     * @return string|null
     */
    public function getGivenName3()
    {
        return $this->givenName3;
    }
    /**
     * Set givenName3 value
     * @param string $givenName3
     * @return \StructType\NameType
     */
    public function setGivenName3($givenName3 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($givenName3) && strlen($givenName3) > 30) || (is_array($givenName3) && count($givenName3) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($givenName3) ? strlen($givenName3) : count($givenName3)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($givenName3) && strlen($givenName3) < 2) || (is_array($givenName3) && count($givenName3) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($givenName3) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $givenName3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($givenName3, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($givenName3) && !is_string($givenName3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($givenName3)), __LINE__);
        }
        $this->givenName3 = $givenName3;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
