<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nameIndexEntityType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Updated version of nniEntityType
 * @subpackage Structs
 */
class NameIndexEntityType extends BaseNniEntityType
{
    /**
     * The abrEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AbrEntityType
     */
    public $abrEntity;
    /**
     * The agentAppointed
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $agentAppointed;
    /**
     * Constructor method for nameIndexEntityType
     * @uses NameIndexEntityType::setAbrEntity()
     * @uses NameIndexEntityType::setAgentAppointed()
     * @param \StructType\AbrEntityType $abrEntity
     * @param bool $agentAppointed
     */
    public function __construct(\StructType\AbrEntityType $abrEntity = null, $agentAppointed = null)
    {
        $this
            ->setAbrEntity($abrEntity)
            ->setAgentAppointed($agentAppointed);
    }
    /**
     * Get abrEntity value
     * @return \StructType\AbrEntityType|null
     */
    public function getAbrEntity()
    {
        return $this->abrEntity;
    }
    /**
     * Set abrEntity value
     * @param \StructType\AbrEntityType $abrEntity
     * @return \StructType\NameIndexEntityType
     */
    public function setAbrEntity(\StructType\AbrEntityType $abrEntity = null)
    {
        $this->abrEntity = $abrEntity;
        return $this;
    }
    /**
     * Get agentAppointed value
     * @return bool|null
     */
    public function getAgentAppointed()
    {
        return $this->agentAppointed;
    }
    /**
     * Set agentAppointed value
     * @param bool $agentAppointed
     * @return \StructType\NameIndexEntityType
     */
    public function setAgentAppointed($agentAppointed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($agentAppointed) && !preg_match('/true/', $agentAppointed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($agentAppointed, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($agentAppointed) && !is_bool($agentAppointed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($agentAppointed)), __LINE__);
        }
        $this->agentAppointed = $agentAppointed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NameIndexEntityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
