<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nameAvailabilityResponseType StructType
 * @subpackage Structs
 */
class NameAvailabilityResponseType extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The shortDescription
     * Meta informations extracted from the WSDL
     * - maxLength: 2500
     * @var string
     */
    public $shortDescription;
    /**
     * The longDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2500
     * @var string
     */
    public $longDescription;
    /**
     * The objection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\ObjectionType[]
     */
    public $objection;
    /**
     * Constructor method for nameAvailabilityResponseType
     * @uses NameAvailabilityResponseType::setCode()
     * @uses NameAvailabilityResponseType::setShortDescription()
     * @uses NameAvailabilityResponseType::setLongDescription()
     * @uses NameAvailabilityResponseType::setObjection()
     * @param string $code
     * @param string $shortDescription
     * @param string $longDescription
     * @param \StructType\ObjectionType[] $objection
     */
    public function __construct($code = null, $shortDescription = null, $longDescription = null, array $objection = array())
    {
        $this
            ->setCode($code)
            ->setShortDescription($shortDescription)
            ->setLongDescription($longDescription)
            ->setObjection($objection);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \EnumType\Code::valueIsValid()
     * @uses \EnumType\Code::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\NameAvailabilityResponseType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Code::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\Code::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get shortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->shortDescription;
    }
    /**
     * Set shortDescription value
     * @param string $shortDescription
     * @return \StructType\NameAvailabilityResponseType
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shortDescription) && strlen($shortDescription) > 2500) || (is_array($shortDescription) && count($shortDescription) > 2500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2500 element(s) or a scalar of 2500 character(s) at most, "%d" length given', is_scalar($shortDescription) ? strlen($shortDescription) : count($shortDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortDescription)), __LINE__);
        }
        $this->shortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get longDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->longDescription;
    }
    /**
     * Set longDescription value
     * @param string $longDescription
     * @return \StructType\NameAvailabilityResponseType
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($longDescription) && strlen($longDescription) > 2500) || (is_array($longDescription) && count($longDescription) > 2500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2500 element(s) or a scalar of 2500 character(s) at most, "%d" length given', is_scalar($longDescription) ? strlen($longDescription) : count($longDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longDescription)), __LINE__);
        }
        $this->longDescription = $longDescription;
        return $this;
    }
    /**
     * Get objection value
     * @return \StructType\ObjectionType[]|null
     */
    public function getObjection()
    {
        return $this->objection;
    }
    /**
     * Set objection value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectionType[] $objection
     * @return \StructType\NameAvailabilityResponseType
     */
    public function setObjection(array $objection = array())
    {
        foreach ($objection as $nameAvailabilityResponseTypeObjectionItem) {
            // validation for constraint: itemType
            if (!$nameAvailabilityResponseTypeObjectionItem instanceof \StructType\ObjectionType) {
                throw new \InvalidArgumentException(sprintf('The objection property can only contain items of \StructType\ObjectionType, "%s" given', is_object($nameAvailabilityResponseTypeObjectionItem) ? get_class($nameAvailabilityResponseTypeObjectionItem) : gettype($nameAvailabilityResponseTypeObjectionItem)), __LINE__);
            }
        }
        $this->objection = $objection;
        return $this;
    }
    /**
     * Add item to objection value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectionType $item
     * @return \StructType\NameAvailabilityResponseType
     */
    public function addToObjection(\StructType\ObjectionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ObjectionType) {
            throw new \InvalidArgumentException(sprintf('The objection property can only contain items of \StructType\ObjectionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->objection[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NameAvailabilityResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
