<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for locationType StructType
 * @subpackage Structs
 */
class LocationType extends AbstractStructBase
{
    /**
     * The postCode
     * Meta informations extracted from the WSDL
     * - maxLength: 12
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $postCode;
    /**
     * The localityState
     * @var \StructType\LocalityState
     */
    public $localityState;
    /**
     * Constructor method for locationType
     * @uses LocationType::setPostCode()
     * @uses LocationType::setLocalityState()
     * @param string $postCode
     * @param \StructType\LocalityState $localityState
     */
    public function __construct($postCode = null, \StructType\LocalityState $localityState = null)
    {
        $this
            ->setPostCode($postCode)
            ->setLocalityState($localityState);
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \StructType\LocationType
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postCode) && strlen($postCode) > 12) || (is_array($postCode) && count($postCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($postCode) ? strlen($postCode) : count($postCode)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($postCode) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($postCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get localityState value
     * @return \StructType\LocalityState|null
     */
    public function getLocalityState()
    {
        return $this->localityState;
    }
    /**
     * Set localityState value
     * @param \StructType\LocalityState $localityState
     * @return \StructType\LocationType
     */
    public function setLocalityState(\StructType\LocalityState $localityState = null)
    {
        $this->localityState = $localityState;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
