<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for legalName StructType
 * Meta informations extracted from the WSDL
 * - documentation: The legalName describes the legal name of the entity. | The legalName allows for the associated person or organisation to declare their legal name.
 * @subpackage Structs
 */
class LegalName extends AbstractStructBase
{
    /**
     * The organisation
     * @var \StructType\Organisation
     */
    public $organisation;
    /**
     * The individual
     * @var \StructType\Individual
     */
    public $individual;
    /**
     * Constructor method for legalName
     * @uses LegalName::setOrganisation()
     * @uses LegalName::setIndividual()
     * @param \StructType\Organisation $organisation
     * @param \StructType\Individual $individual
     */
    public function __construct(\StructType\Organisation $organisation = null, \StructType\Individual $individual = null)
    {
        $this
            ->setOrganisation($organisation)
            ->setIndividual($individual);
    }
    /**
     * Get organisation value
     * @return \StructType\Organisation|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\Organisation $organisation
     * @return \StructType\LegalName
     */
    public function setOrganisation(\StructType\Organisation $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get individual value
     * @return \StructType\Individual|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\Individual $individual
     * @return \StructType\LegalName
     */
    public function setIndividual(\StructType\Individual $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LegalName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
