<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemSearchScopeType StructType
 * @subpackage Structs
 */
class ItemSearchScopeType extends AbstractStructBase
{
    /**
     * The itemType
     * @var string
     */
    public $itemType;
    /**
     * The messageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $messageType;
    /**
     * The reportingEntityAbn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $reportingEntityAbn;
    /**
     * The reportingEntityAcn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $reportingEntityAcn;
    /**
     * The dateStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateStart;
    /**
     * The dateEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateEnd;
    /**
     * The unreadOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $unreadOnly;
    /**
     * Constructor method for itemSearchScopeType
     * @uses ItemSearchScopeType::setItemType()
     * @uses ItemSearchScopeType::setMessageType()
     * @uses ItemSearchScopeType::setReportingEntityAbn()
     * @uses ItemSearchScopeType::setReportingEntityAcn()
     * @uses ItemSearchScopeType::setDateStart()
     * @uses ItemSearchScopeType::setDateEnd()
     * @uses ItemSearchScopeType::setUnreadOnly()
     * @param string $itemType
     * @param string $messageType
     * @param string $reportingEntityAbn
     * @param int $reportingEntityAcn
     * @param string $dateStart
     * @param string $dateEnd
     * @param bool $unreadOnly
     */
    public function __construct($itemType = null, $messageType = null, $reportingEntityAbn = null, $reportingEntityAcn = null, $dateStart = null, $dateEnd = null, $unreadOnly = null)
    {
        $this
            ->setItemType($itemType)
            ->setMessageType($messageType)
            ->setReportingEntityAbn($reportingEntityAbn)
            ->setReportingEntityAcn($reportingEntityAcn)
            ->setDateStart($dateStart)
            ->setDateEnd($dateEnd)
            ->setUnreadOnly($unreadOnly);
    }
    /**
     * Get itemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->itemType;
    }
    /**
     * Set itemType value
     * @uses \EnumType\ItemTypeType::valueIsValid()
     * @uses \EnumType\ItemTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \StructType\ItemSearchScopeType
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemTypeType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $itemType, implode(', ', \EnumType\ItemTypeType::getValidValues())), __LINE__);
        }
        $this->itemType = $itemType;
        return $this;
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\ItemSearchScopeType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageType) && strlen($messageType) > 100) || (is_array($messageType) && count($messageType) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($messageType) ? strlen($messageType) : count($messageType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageType) && strlen($messageType) < 1) || (is_array($messageType) && count($messageType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get reportingEntityAbn value
     * @return string|null
     */
    public function getReportingEntityAbn()
    {
        return $this->reportingEntityAbn;
    }
    /**
     * Set reportingEntityAbn value
     * @param string $reportingEntityAbn
     * @return \StructType\ItemSearchScopeType
     */
    public function setReportingEntityAbn($reportingEntityAbn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reportingEntityAbn) && strlen($reportingEntityAbn) > 11) || (is_array($reportingEntityAbn) && count($reportingEntityAbn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($reportingEntityAbn) ? strlen($reportingEntityAbn) : count($reportingEntityAbn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reportingEntityAbn) && strlen($reportingEntityAbn) < 11) || (is_array($reportingEntityAbn) && count($reportingEntityAbn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($reportingEntityAbn) && !preg_match('/([0-9]{11})/', $reportingEntityAbn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($reportingEntityAbn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reportingEntityAbn) && !is_string($reportingEntityAbn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reportingEntityAbn)), __LINE__);
        }
        $this->reportingEntityAbn = $reportingEntityAbn;
        return $this;
    }
    /**
     * Get reportingEntityAcn value
     * @return int|null
     */
    public function getReportingEntityAcn()
    {
        return $this->reportingEntityAcn;
    }
    /**
     * Set reportingEntityAcn value
     * @param int $reportingEntityAcn
     * @return \StructType\ItemSearchScopeType
     */
    public function setReportingEntityAcn($reportingEntityAcn = null)
    {
        // validation for constraint: maxInclusive
        if ($reportingEntityAcn > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $reportingEntityAcn), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($reportingEntityAcn < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $reportingEntityAcn), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($reportingEntityAcn) && !is_numeric($reportingEntityAcn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportingEntityAcn)), __LINE__);
        }
        $this->reportingEntityAcn = $reportingEntityAcn;
        return $this;
    }
    /**
     * Get dateStart value
     * @return string|null
     */
    public function getDateStart()
    {
        return $this->dateStart;
    }
    /**
     * Set dateStart value
     * @param string $dateStart
     * @return \StructType\ItemSearchScopeType
     */
    public function setDateStart($dateStart = null)
    {
        // validation for constraint: minInclusive
        if ($dateStart < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateStart), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateStart) && !is_string($dateStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateStart)), __LINE__);
        }
        $this->dateStart = $dateStart;
        return $this;
    }
    /**
     * Get dateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }
    /**
     * Set dateEnd value
     * @param string $dateEnd
     * @return \StructType\ItemSearchScopeType
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: minInclusive
        if ($dateEnd < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateEnd), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEnd)), __LINE__);
        }
        $this->dateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get unreadOnly value
     * @return bool|null
     */
    public function getUnreadOnly()
    {
        return $this->unreadOnly;
    }
    /**
     * Set unreadOnly value
     * @param bool $unreadOnly
     * @return \StructType\ItemSearchScopeType
     */
    public function setUnreadOnly($unreadOnly = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unreadOnly) && !preg_match('/true/', $unreadOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($unreadOnly, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($unreadOnly) && !is_bool($unreadOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unreadOnly)), __LINE__);
        }
        $this->unreadOnly = $unreadOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemSearchScopeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
