<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invoicePeriod StructType
 * @subpackage Structs
 */
class InvoicePeriod extends AbstractStructBase
{
    /**
     * The dateStart
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateStart;
    /**
     * The dateEnd
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateEnd;
    /**
     * Constructor method for invoicePeriod
     * @uses InvoicePeriod::setDateStart()
     * @uses InvoicePeriod::setDateEnd()
     * @param string $dateStart
     * @param string $dateEnd
     */
    public function __construct($dateStart = null, $dateEnd = null)
    {
        $this
            ->setDateStart($dateStart)
            ->setDateEnd($dateEnd);
    }
    /**
     * Get dateStart value
     * @return string|null
     */
    public function getDateStart()
    {
        return $this->dateStart;
    }
    /**
     * Set dateStart value
     * @param string $dateStart
     * @return \StructType\InvoicePeriod
     */
    public function setDateStart($dateStart = null)
    {
        // validation for constraint: minInclusive
        if ($dateStart < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateStart), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateStart) && !is_string($dateStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateStart)), __LINE__);
        }
        $this->dateStart = $dateStart;
        return $this;
    }
    /**
     * Get dateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }
    /**
     * Set dateEnd value
     * @param string $dateEnd
     * @return \StructType\InvoicePeriod
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: minInclusive
        if ($dateEnd < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateEnd), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEnd)), __LINE__);
        }
        $this->dateEnd = $dateEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoicePeriod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
