<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for individualNameType StructType
 * @subpackage Structs
 */
class IndividualNameType extends AbstractStructBase
{
    /**
     * The titleTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: The titleTypeCode describes the title to be used in addressing a person by name, whether by mail, by phone, or in person (e.g. Mr, Mrs, Miss, Ms).
     * - minOccurs: 0
     * - maxLength: 12
     * @var string
     */
    public $titleTypeCode;
    /**
     * The givenName
     * Meta informations extracted from the WSDL
     * - documentation: The givenName stores the first name given to a person party which is that person's identifying name within the family group or the name by which the person is socially identified.
     * - maxLength: 40
     * @var string
     */
    public $givenName;
    /**
     * The otherGivenName
     * Meta informations extracted from the WSDL
     * - documentation: The otherGivenName stores any second and subsequent names given to a person party which forms part of that person's identifying name within the family group or the name by which the person is socially identified.
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $otherGivenName;
    /**
     * The familyName
     * Meta informations extracted from the WSDL
     * - documentation: The familyName stores the person party’s family name or surname by which the family group is identified.
     * - maxLength: 40
     * @var string
     */
    public $familyName;
    /**
     * The suffixTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: The suffixTypeCode stores honours, awards and other identifiers following a person party’s name.
     * - minOccurs: 0
     * - maxLength: 5
     * @var string
     */
    public $suffixTypeCode;
    /**
     * The effectiveFrom
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveFrom defines the date from which a name is effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveFrom;
    /**
     * The effectiveTo
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveTo defines the date from which a name is no longer effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveTo;
    /**
     * The deleteIndicator
     * Meta informations extracted from the WSDL
     * - documentation: The deleteIndicator indicates whether the name record has been logically deleted from the system.
     * - minOccurs: 0
     * @var string
     */
    public $deleteIndicator;
    /**
     * Constructor method for individualNameType
     * @uses IndividualNameType::setTitleTypeCode()
     * @uses IndividualNameType::setGivenName()
     * @uses IndividualNameType::setOtherGivenName()
     * @uses IndividualNameType::setFamilyName()
     * @uses IndividualNameType::setSuffixTypeCode()
     * @uses IndividualNameType::setEffectiveFrom()
     * @uses IndividualNameType::setEffectiveTo()
     * @uses IndividualNameType::setDeleteIndicator()
     * @param string $titleTypeCode
     * @param string $givenName
     * @param string $otherGivenName
     * @param string $familyName
     * @param string $suffixTypeCode
     * @param string $effectiveFrom
     * @param string $effectiveTo
     * @param string $deleteIndicator
     */
    public function __construct($titleTypeCode = null, $givenName = null, $otherGivenName = null, $familyName = null, $suffixTypeCode = null, $effectiveFrom = null, $effectiveTo = null, $deleteIndicator = null)
    {
        $this
            ->setTitleTypeCode($titleTypeCode)
            ->setGivenName($givenName)
            ->setOtherGivenName($otherGivenName)
            ->setFamilyName($familyName)
            ->setSuffixTypeCode($suffixTypeCode)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveTo($effectiveTo)
            ->setDeleteIndicator($deleteIndicator);
    }
    /**
     * Get titleTypeCode value
     * @return string|null
     */
    public function getTitleTypeCode()
    {
        return $this->titleTypeCode;
    }
    /**
     * Set titleTypeCode value
     * @param string $titleTypeCode
     * @return \StructType\IndividualNameType
     */
    public function setTitleTypeCode($titleTypeCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($titleTypeCode) && strlen($titleTypeCode) > 12) || (is_array($titleTypeCode) && count($titleTypeCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($titleTypeCode) ? strlen($titleTypeCode) : count($titleTypeCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($titleTypeCode) && !is_string($titleTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titleTypeCode)), __LINE__);
        }
        $this->titleTypeCode = $titleTypeCode;
        return $this;
    }
    /**
     * Get givenName value
     * @return string|null
     */
    public function getGivenName()
    {
        return $this->givenName;
    }
    /**
     * Set givenName value
     * @param string $givenName
     * @return \StructType\IndividualNameType
     */
    public function setGivenName($givenName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($givenName) && strlen($givenName) > 40) || (is_array($givenName) && count($givenName) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($givenName) ? strlen($givenName) : count($givenName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($givenName) && !is_string($givenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($givenName)), __LINE__);
        }
        $this->givenName = $givenName;
        return $this;
    }
    /**
     * Get otherGivenName value
     * @return string|null
     */
    public function getOtherGivenName()
    {
        return $this->otherGivenName;
    }
    /**
     * Set otherGivenName value
     * @param string $otherGivenName
     * @return \StructType\IndividualNameType
     */
    public function setOtherGivenName($otherGivenName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($otherGivenName) && strlen($otherGivenName) > 100) || (is_array($otherGivenName) && count($otherGivenName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($otherGivenName) ? strlen($otherGivenName) : count($otherGivenName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($otherGivenName) && !is_string($otherGivenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherGivenName)), __LINE__);
        }
        $this->otherGivenName = $otherGivenName;
        return $this;
    }
    /**
     * Get familyName value
     * @return string|null
     */
    public function getFamilyName()
    {
        return $this->familyName;
    }
    /**
     * Set familyName value
     * @param string $familyName
     * @return \StructType\IndividualNameType
     */
    public function setFamilyName($familyName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($familyName) && strlen($familyName) > 40) || (is_array($familyName) && count($familyName) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($familyName) ? strlen($familyName) : count($familyName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($familyName) && !is_string($familyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($familyName)), __LINE__);
        }
        $this->familyName = $familyName;
        return $this;
    }
    /**
     * Get suffixTypeCode value
     * @return string|null
     */
    public function getSuffixTypeCode()
    {
        return $this->suffixTypeCode;
    }
    /**
     * Set suffixTypeCode value
     * @param string $suffixTypeCode
     * @return \StructType\IndividualNameType
     */
    public function setSuffixTypeCode($suffixTypeCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($suffixTypeCode) && strlen($suffixTypeCode) > 5) || (is_array($suffixTypeCode) && count($suffixTypeCode) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($suffixTypeCode) ? strlen($suffixTypeCode) : count($suffixTypeCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($suffixTypeCode) && !is_string($suffixTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffixTypeCode)), __LINE__);
        }
        $this->suffixTypeCode = $suffixTypeCode;
        return $this;
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\IndividualNameType
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get effectiveTo value
     * @return string|null
     */
    public function getEffectiveTo()
    {
        return $this->effectiveTo;
    }
    /**
     * Set effectiveTo value
     * @param string $effectiveTo
     * @return \StructType\IndividualNameType
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        $this->effectiveTo = $effectiveTo;
        return $this;
    }
    /**
     * Get deleteIndicator value
     * @return string|null
     */
    public function getDeleteIndicator()
    {
        return $this->deleteIndicator;
    }
    /**
     * Set deleteIndicator value
     * @uses \EnumType\IndicatorType::valueIsValid()
     * @uses \EnumType\IndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deleteIndicator
     * @return \StructType\IndividualNameType
     */
    public function setDeleteIndicator($deleteIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicatorType::valueIsValid($deleteIndicator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deleteIndicator, implode(', ', \EnumType\IndicatorType::getValidValues())), __LINE__);
        }
        $this->deleteIndicator = $deleteIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IndividualNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
