<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for identifier StructType
 * @subpackage Structs
 */
class Identifier extends AbstractStructBase
{
    /**
     * The browser
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * @var \StructType\BrowserIdentifierType
     */
    public $browser;
    /**
     * The soap
     * @var \StructType\SoapSoftwareIdentifierType
     */
    public $soap;
    /**
     * The internal
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - pattern: true
     * @var bool
     */
    public $internal;
    /**
     * Constructor method for identifier
     * @uses Identifier::setBrowser()
     * @uses Identifier::setSoap()
     * @uses Identifier::setInternal()
     * @param \StructType\BrowserIdentifierType $browser
     * @param \StructType\SoapSoftwareIdentifierType $soap
     * @param bool $internal
     */
    public function __construct(\StructType\BrowserIdentifierType $browser = null, \StructType\SoapSoftwareIdentifierType $soap = null, $internal = null)
    {
        $this
            ->setBrowser($browser)
            ->setSoap($soap)
            ->setInternal($internal);
    }
    /**
     * Get browser value
     * @return \StructType\BrowserIdentifierType|null
     */
    public function getBrowser()
    {
        return $this->browser;
    }
    /**
     * Set browser value
     * @param \StructType\BrowserIdentifierType $browser
     * @return \StructType\Identifier
     */
    public function setBrowser(\StructType\BrowserIdentifierType $browser = null)
    {
        $this->browser = $browser;
        return $this;
    }
    /**
     * Get soap value
     * @return \StructType\SoapSoftwareIdentifierType|null
     */
    public function getSoap()
    {
        return $this->soap;
    }
    /**
     * Set soap value
     * @param \StructType\SoapSoftwareIdentifierType $soap
     * @return \StructType\Identifier
     */
    public function setSoap(\StructType\SoapSoftwareIdentifierType $soap = null)
    {
        $this->soap = $soap;
        return $this;
    }
    /**
     * Get internal value
     * @return bool|null
     */
    public function getInternal()
    {
        return $this->internal;
    }
    /**
     * Set internal value
     * @param bool $internal
     * @return \StructType\Identifier
     */
    public function setInternal($internal = null)
    {
        // validation for constraint: pattern
        if (is_scalar($internal) && !preg_match('/true/', $internal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($internal, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($internal) && !is_bool($internal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($internal)), __LINE__);
        }
        $this->internal = $internal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Identifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
