<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for genericResultType StructType
 * @subpackage Structs
 */
class GenericResultType extends AbstractStructBase
{
    /**
     * The accepted
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $accepted;
    /**
     * The rejected
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $rejected;
    /**
     * The delayed
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $delayed;
    /**
     * The fault
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $fault;
    /**
     * Constructor method for genericResultType
     * @uses GenericResultType::setAccepted()
     * @uses GenericResultType::setRejected()
     * @uses GenericResultType::setDelayed()
     * @uses GenericResultType::setFault()
     * @param bool $accepted
     * @param bool $rejected
     * @param bool $delayed
     * @param bool $fault
     */
    public function __construct($accepted = null, $rejected = null, $delayed = null, $fault = null)
    {
        $this
            ->setAccepted($accepted)
            ->setRejected($rejected)
            ->setDelayed($delayed)
            ->setFault($fault);
    }
    /**
     * Get accepted value
     * @return bool|null
     */
    public function getAccepted()
    {
        return $this->accepted;
    }
    /**
     * Set accepted value
     * @param bool $accepted
     * @return \StructType\GenericResultType
     */
    public function setAccepted($accepted = null)
    {
        // validation for constraint: pattern
        if (is_scalar($accepted) && !preg_match('/true/', $accepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($accepted, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($accepted) && !is_bool($accepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accepted)), __LINE__);
        }
        $this->accepted = $accepted;
        return $this;
    }
    /**
     * Get rejected value
     * @return bool|null
     */
    public function getRejected()
    {
        return $this->rejected;
    }
    /**
     * Set rejected value
     * @param bool $rejected
     * @return \StructType\GenericResultType
     */
    public function setRejected($rejected = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejected) && !preg_match('/true/', $rejected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($rejected, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($rejected) && !is_bool($rejected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rejected)), __LINE__);
        }
        $this->rejected = $rejected;
        return $this;
    }
    /**
     * Get delayed value
     * @return bool|null
     */
    public function getDelayed()
    {
        return $this->delayed;
    }
    /**
     * Set delayed value
     * @param bool $delayed
     * @return \StructType\GenericResultType
     */
    public function setDelayed($delayed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($delayed) && !preg_match('/true/', $delayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($delayed, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($delayed) && !is_bool($delayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($delayed)), __LINE__);
        }
        $this->delayed = $delayed;
        return $this;
    }
    /**
     * Get fault value
     * @return bool|null
     */
    public function getFault()
    {
        return $this->fault;
    }
    /**
     * Set fault value
     * @param bool $fault
     * @return \StructType\GenericResultType
     */
    public function setFault($fault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($fault) && !preg_match('/true/', $fault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($fault, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($fault) && !is_bool($fault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fault)), __LINE__);
        }
        $this->fault = $fault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
