<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fssTransactionType StructType
 * @subpackage Structs
 */
class FssTransactionType extends AbstractStructBase
{
    /**
     * The dueDate
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dueDate;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The referenceId
     * Meta informations extracted from the WSDL
     * - maxLength: 254
     * @var string
     */
    public $referenceId;
    /**
     * The allocationReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 254
     * @var string
     */
    public $allocationReference;
    /**
     * The originalAmount
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $originalAmount;
    /**
     * The outstandingAmount
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $outstandingAmount;
    /**
     * Constructor method for fssTransactionType
     * @uses FssTransactionType::setDueDate()
     * @uses FssTransactionType::setType()
     * @uses FssTransactionType::setDescription()
     * @uses FssTransactionType::setReferenceId()
     * @uses FssTransactionType::setAllocationReference()
     * @uses FssTransactionType::setOriginalAmount()
     * @uses FssTransactionType::setOutstandingAmount()
     * @param string $dueDate
     * @param string $type
     * @param string $description
     * @param string $referenceId
     * @param string $allocationReference
     * @param float $originalAmount
     * @param float $outstandingAmount
     */
    public function __construct($dueDate = null, $type = null, $description = null, $referenceId = null, $allocationReference = null, $originalAmount = null, $outstandingAmount = null)
    {
        $this
            ->setDueDate($dueDate)
            ->setType($type)
            ->setDescription($description)
            ->setReferenceId($referenceId)
            ->setAllocationReference($allocationReference)
            ->setOriginalAmount($originalAmount)
            ->setOutstandingAmount($outstandingAmount);
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\FssTransactionType
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: minInclusive
        if ($dueDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dueDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\FssTransactionType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\FssTransactionType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 60) || (is_array($description) && count($description) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get referenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }
    /**
     * Set referenceId value
     * @param string $referenceId
     * @return \StructType\FssTransactionType
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referenceId) && strlen($referenceId) > 254) || (is_array($referenceId) && count($referenceId) > 254)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 254 element(s) or a scalar of 254 character(s) at most, "%d" length given', is_scalar($referenceId) ? strlen($referenceId) : count($referenceId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceId)), __LINE__);
        }
        $this->referenceId = $referenceId;
        return $this;
    }
    /**
     * Get allocationReference value
     * @return string|null
     */
    public function getAllocationReference()
    {
        return $this->allocationReference;
    }
    /**
     * Set allocationReference value
     * @param string $allocationReference
     * @return \StructType\FssTransactionType
     */
    public function setAllocationReference($allocationReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($allocationReference) && strlen($allocationReference) > 254) || (is_array($allocationReference) && count($allocationReference) > 254)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 254 element(s) or a scalar of 254 character(s) at most, "%d" length given', is_scalar($allocationReference) ? strlen($allocationReference) : count($allocationReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allocationReference) && !is_string($allocationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allocationReference)), __LINE__);
        }
        $this->allocationReference = $allocationReference;
        return $this;
    }
    /**
     * Get originalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->originalAmount;
    }
    /**
     * Set originalAmount value
     * @param float $originalAmount
     * @return \StructType\FssTransactionType
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($originalAmount) && strlen(substr($originalAmount, strpos($originalAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($originalAmount, strpos($originalAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($originalAmount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $originalAmount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($originalAmount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $originalAmount), __LINE__);
        }
        $this->originalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get outstandingAmount value
     * @return float|null
     */
    public function getOutstandingAmount()
    {
        return $this->outstandingAmount;
    }
    /**
     * Set outstandingAmount value
     * @param float $outstandingAmount
     * @return \StructType\FssTransactionType
     */
    public function setOutstandingAmount($outstandingAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($outstandingAmount) && strlen(substr($outstandingAmount, strpos($outstandingAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($outstandingAmount, strpos($outstandingAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($outstandingAmount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $outstandingAmount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($outstandingAmount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $outstandingAmount), __LINE__);
        }
        $this->outstandingAmount = $outstandingAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FssTransactionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
