<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fssAccountType StructType
 * @subpackage Structs
 */
class FssAccountType extends AbstractStructBase
{
    /**
     * The asicType
     * Meta informations extracted from the WSDL
     * - documentation: APTY Australian Private CompanyAPUB Australian Public CompanyBUSN Business NameREGA Regsitered Agent...
     * - maxLength: 4
     * @var string
     */
    public $asicType;
    /**
     * The ledgerNumber
     * Meta informations extracted from the WSDL
     * - documentation: 22 Companies Lodging33 Professional Licensees e.g. Auditors, Liquidators34 FSR Licensees35 Credit Licensees44 9103 - Annual Return PenaltiesMiscellaneous Payments/Annual Return Compliance55 Registered Agent Lodging75 ECharges Direct
     * Debit77 ECR Direct Debit85 Business Names99 Sundry Debtor | 22 Companies Lodging33 Professional Licensees e.g. Auditors, Liquidators34 FSR Licensees35 Credit Licensees44 9103 - Annual Return PenaltiesMiscellaneous Payments/Annual Return Compliance55
     * Registered Agent Lodging75 ECharges Direct Debit77 ECR Direct Debit85 Business Names99 Sundry Debtor
     * - maxInclusive: 99
     * - minInclusive: 1
     * - totalDigits: 2 | 9
     * @var int
     */
    public $ledgerNumber;
    /**
     * The asicIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: ASIC IdentifierACNBNNARBNARSNLicense NumberRegistered Agent Number | ASIC IdentifierACNBNNARBNARSNLicense NumberRegistered Agent Number
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * - totalDigits: 9
     * @var int
     */
    public $asicIdentifier;
    /**
     * Constructor method for fssAccountType
     * @uses FssAccountType::setAsicType()
     * @uses FssAccountType::setLedgerNumber()
     * @uses FssAccountType::setAsicIdentifier()
     * @param string $asicType
     * @param int $ledgerNumber
     * @param int $asicIdentifier
     */
    public function __construct($asicType = null, $ledgerNumber = null, $asicIdentifier = null)
    {
        $this
            ->setAsicType($asicType)
            ->setLedgerNumber($ledgerNumber)
            ->setAsicIdentifier($asicIdentifier);
    }
    /**
     * Get asicType value
     * @return string|null
     */
    public function getAsicType()
    {
        return $this->asicType;
    }
    /**
     * Set asicType value
     * @param string $asicType
     * @return \StructType\FssAccountType
     */
    public function setAsicType($asicType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asicType) && strlen($asicType) > 4) || (is_array($asicType) && count($asicType) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($asicType) ? strlen($asicType) : count($asicType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asicType) && !is_string($asicType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicType)), __LINE__);
        }
        $this->asicType = $asicType;
        return $this;
    }
    /**
     * Get ledgerNumber value
     * @return int|null
     */
    public function getLedgerNumber()
    {
        return $this->ledgerNumber;
    }
    /**
     * Set ledgerNumber value
     * @param int $ledgerNumber
     * @return \StructType\FssAccountType
     */
    public function setLedgerNumber($ledgerNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($ledgerNumber > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99, "%s" given', $ledgerNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ledgerNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $ledgerNumber), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($ledgerNumber) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $ledgerNumber)) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 digits, "%d" given', strlen(substr($ledgerNumber, strpos($ledgerNumber, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ledgerNumber) && !is_numeric($ledgerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ledgerNumber)), __LINE__);
        }
        $this->ledgerNumber = $ledgerNumber;
        return $this;
    }
    /**
     * Get asicIdentifier value
     * @return int|null
     */
    public function getAsicIdentifier()
    {
        return $this->asicIdentifier;
    }
    /**
     * Set asicIdentifier value
     * @param int $asicIdentifier
     * @return \StructType\FssAccountType
     */
    public function setAsicIdentifier($asicIdentifier = null)
    {
        // validation for constraint: maxInclusive
        if ($asicIdentifier > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $asicIdentifier), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($asicIdentifier < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $asicIdentifier), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($asicIdentifier) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $asicIdentifier)) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 9 digits, "%d" given', strlen(substr($asicIdentifier, strpos($asicIdentifier, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($asicIdentifier) && !is_numeric($asicIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($asicIdentifier)), __LINE__);
        }
        $this->asicIdentifier = $asicIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FssAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
