<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for filter StructType
 * @subpackage Structs
 */
class Filter extends AbstractStructBase
{
    /**
     * The roleCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $roleCategory;
    /**
     * The statusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $statusCode;
    /**
     * The principalPlaceOfBusiness
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $principalPlaceOfBusiness;
    /**
     * Constructor method for filter
     * @uses Filter::setRoleCategory()
     * @uses Filter::setStatusCode()
     * @uses Filter::setPrincipalPlaceOfBusiness()
     * @param string $roleCategory
     * @param string[] $statusCode
     * @param \StructType\LocationType $principalPlaceOfBusiness
     */
    public function __construct($roleCategory = null, array $statusCode = array(), \StructType\LocationType $principalPlaceOfBusiness = null)
    {
        $this
            ->setRoleCategory($roleCategory)
            ->setStatusCode($statusCode)
            ->setPrincipalPlaceOfBusiness($principalPlaceOfBusiness);
    }
    /**
     * Get roleCategory value
     * @return string|null
     */
    public function getRoleCategory()
    {
        return $this->roleCategory;
    }
    /**
     * Set roleCategory value
     * @uses \EnumType\RoleCategory::valueIsValid()
     * @uses \EnumType\RoleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleCategory
     * @return \StructType\Filter
     */
    public function setRoleCategory($roleCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoleCategory::valueIsValid($roleCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roleCategory, implode(', ', \EnumType\RoleCategory::getValidValues())), __LINE__);
        }
        $this->roleCategory = $roleCategory;
        return $this;
    }
    /**
     * Get statusCode value
     * @return string[]|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @uses \EnumType\BnSearchStatusCodeType::valueIsValid()
     * @uses \EnumType\BnSearchStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statusCode
     * @return \StructType\Filter
     */
    public function setStatusCode(array $statusCode = array())
    {
        $invalidValues = array();
        foreach ($statusCode as $filterStatusCodeItem) {
            if (!\EnumType\BnSearchStatusCodeType::valueIsValid($filterStatusCodeItem)) {
                $invalidValues[] = var_export($filterStatusCodeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\BnSearchStatusCodeType::getValidValues())), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Add item to statusCode value
     * @uses \EnumType\BnSearchStatusCodeType::valueIsValid()
     * @uses \EnumType\BnSearchStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Filter
     */
    public function addToStatusCode($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BnSearchStatusCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\BnSearchStatusCodeType::getValidValues())), __LINE__);
        }
        $this->statusCode[] = $item;
        return $this;
    }
    /**
     * Get principalPlaceOfBusiness value
     * @return \StructType\LocationType|null
     */
    public function getPrincipalPlaceOfBusiness()
    {
        return $this->principalPlaceOfBusiness;
    }
    /**
     * Set principalPlaceOfBusiness value
     * @param \StructType\LocationType $principalPlaceOfBusiness
     * @return \StructType\Filter
     */
    public function setPrincipalPlaceOfBusiness(\StructType\LocationType $principalPlaceOfBusiness = null)
    {
        $this->principalPlaceOfBusiness = $principalPlaceOfBusiness;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Filter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
