<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for feesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: ** DEPRECATED**Asic output of statutory fees
 * @subpackage Structs
 */
class FeesType extends AbstractStructBase
{
    /**
     * The lodgementUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Internal Ascot Ids ie N9
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $lodgementUnit;
    /**
     * The lodgementDate
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $lodgementDate;
    /**
     * The paymentMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethod;
    /**
     * The totalAmountOwing
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $totalAmountOwing;
    /**
     * The invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Invoice
     */
    public $invoice;
    /**
     * Constructor method for feesType
     * @uses FeesType::setLodgementUnit()
     * @uses FeesType::setLodgementDate()
     * @uses FeesType::setPaymentMethod()
     * @uses FeesType::setTotalAmountOwing()
     * @uses FeesType::setInvoice()
     * @param int $lodgementUnit
     * @param string $lodgementDate
     * @param string $paymentMethod
     * @param float $totalAmountOwing
     * @param \StructType\Invoice $invoice
     */
    public function __construct($lodgementUnit = null, $lodgementDate = null, $paymentMethod = null, $totalAmountOwing = null, \StructType\Invoice $invoice = null)
    {
        $this
            ->setLodgementUnit($lodgementUnit)
            ->setLodgementDate($lodgementDate)
            ->setPaymentMethod($paymentMethod)
            ->setTotalAmountOwing($totalAmountOwing)
            ->setInvoice($invoice);
    }
    /**
     * Get lodgementUnit value
     * @return int|null
     */
    public function getLodgementUnit()
    {
        return $this->lodgementUnit;
    }
    /**
     * Set lodgementUnit value
     * @param int $lodgementUnit
     * @return \StructType\FeesType
     */
    public function setLodgementUnit($lodgementUnit = null)
    {
        // validation for constraint: maxInclusive
        if ($lodgementUnit > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $lodgementUnit), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($lodgementUnit < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $lodgementUnit), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($lodgementUnit) && !is_numeric($lodgementUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lodgementUnit)), __LINE__);
        }
        $this->lodgementUnit = $lodgementUnit;
        return $this;
    }
    /**
     * Get lodgementDate value
     * @return string|null
     */
    public function getLodgementDate()
    {
        return $this->lodgementDate;
    }
    /**
     * Set lodgementDate value
     * @param string $lodgementDate
     * @return \StructType\FeesType
     */
    public function setLodgementDate($lodgementDate = null)
    {
        // validation for constraint: minInclusive
        if ($lodgementDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $lodgementDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lodgementDate) && !is_string($lodgementDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lodgementDate)), __LINE__);
        }
        $this->lodgementDate = $lodgementDate;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @uses \EnumType\PaymentMethodType::valueIsValid()
     * @uses \EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethod
     * @return \StructType\FeesType
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentMethodType::valueIsValid($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentMethod, implode(', ', \EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get totalAmountOwing value
     * @return float|null
     */
    public function getTotalAmountOwing()
    {
        return $this->totalAmountOwing;
    }
    /**
     * Set totalAmountOwing value
     * @param float $totalAmountOwing
     * @return \StructType\FeesType
     */
    public function setTotalAmountOwing($totalAmountOwing = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($totalAmountOwing) && strlen(substr($totalAmountOwing, strpos($totalAmountOwing, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($totalAmountOwing, strpos($totalAmountOwing, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($totalAmountOwing > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $totalAmountOwing), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($totalAmountOwing < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $totalAmountOwing), __LINE__);
        }
        $this->totalAmountOwing = $totalAmountOwing;
        return $this;
    }
    /**
     * Get invoice value
     * @return \StructType\Invoice|null
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @param \StructType\Invoice $invoice
     * @return \StructType\FeesType
     */
    public function setInvoice(\StructType\Invoice $invoice = null)
    {
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
