<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for feeType StructType
 * Meta informations extracted from the WSDL
 * - maxLength: 5
 * @subpackage Structs
 */
class FeeType extends AbstractStructBase
{
    /**
     * The feeType
     * @var \StructType\FeeType
     */
    public $feeType;
    /**
     * The feeSubType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $feeSubType;
    /**
     * The feeDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $feeDescription;
    /**
     * Constructor method for feeType
     * @uses FeeType::setFeeType()
     * @uses FeeType::setFeeSubType()
     * @uses FeeType::setFeeDescription()
     * @param \StructType\FeeType $feeType
     * @param string $feeSubType
     * @param string $feeDescription
     */
    public function __construct(\StructType\FeeType $feeType = null, $feeSubType = null, $feeDescription = null)
    {
        $this
            ->setFeeType($feeType)
            ->setFeeSubType($feeSubType)
            ->setFeeDescription($feeDescription);
    }
    /**
     * Get feeType value
     * @return \StructType\FeeType|null
     */
    public function getFeeType()
    {
        return $this->feeType;
    }
    /**
     * Set feeType value
     * @param \StructType\FeeType $feeType
     * @return \StructType\FeeType
     */
    public function setFeeType(\StructType\FeeType $feeType = null)
    {
        $this->feeType = $feeType;
        return $this;
    }
    /**
     * Get feeSubType value
     * @return string|null
     */
    public function getFeeSubType()
    {
        return $this->feeSubType;
    }
    /**
     * Set feeSubType value
     * @param string $feeSubType
     * @return \StructType\FeeType
     */
    public function setFeeSubType($feeSubType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($feeSubType) && strlen($feeSubType) > 2) || (is_array($feeSubType) && count($feeSubType) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($feeSubType) ? strlen($feeSubType) : count($feeSubType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($feeSubType) && !is_string($feeSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeSubType)), __LINE__);
        }
        $this->feeSubType = $feeSubType;
        return $this;
    }
    /**
     * Get feeDescription value
     * @return string|null
     */
    public function getFeeDescription()
    {
        return $this->feeDescription;
    }
    /**
     * Set feeDescription value
     * @param string $feeDescription
     * @return \StructType\FeeType
     */
    public function setFeeDescription($feeDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($feeDescription) && strlen($feeDescription) > 10) || (is_array($feeDescription) && count($feeDescription) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($feeDescription) ? strlen($feeDescription) : count($feeDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($feeDescription) && !is_string($feeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeDescription)), __LINE__);
        }
        $this->feeDescription = $feeDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
