<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for entityType StructType
 * @subpackage Structs
 */
class EntityType extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $name;
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The realmQualifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RealmQualifierType
     */
    public $realmQualifier;
    /**
     * The entityType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $entityType;
    /**
     * The sourceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sourceId;
    /**
     * Constructor method for entityType
     * @uses EntityType::setName()
     * @uses EntityType::setAbn()
     * @uses EntityType::setRealmQualifier()
     * @uses EntityType::setEntityType()
     * @uses EntityType::setSourceId()
     * @param string $name
     * @param string $abn
     * @param \StructType\RealmQualifierType $realmQualifier
     * @param string $entityType
     * @param int $sourceId
     */
    public function __construct($name = null, $abn = null, \StructType\RealmQualifierType $realmQualifier = null, $entityType = null, $sourceId = null)
    {
        $this
            ->setName($name)
            ->setAbn($abn)
            ->setRealmQualifier($realmQualifier)
            ->setEntityType($entityType)
            ->setSourceId($sourceId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\EntityType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\EntityType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get realmQualifier value
     * @return \StructType\RealmQualifierType|null
     */
    public function getRealmQualifier()
    {
        return $this->realmQualifier;
    }
    /**
     * Set realmQualifier value
     * @param \StructType\RealmQualifierType $realmQualifier
     * @return \StructType\EntityType
     */
    public function setRealmQualifier(\StructType\RealmQualifierType $realmQualifier = null)
    {
        $this->realmQualifier = $realmQualifier;
        return $this;
    }
    /**
     * Get entityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->entityType;
    }
    /**
     * Set entityType value
     * @param string $entityType
     * @return \StructType\EntityType
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityType)), __LINE__);
        }
        $this->entityType = $entityType;
        return $this;
    }
    /**
     * Get sourceId value
     * @return int|null
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @param int $sourceId
     * @return \StructType\EntityType
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceId) && !is_numeric($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceId)), __LINE__);
        }
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
