<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for document StructType
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The dateListStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateListStart;
    /**
     * The dateListEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateListEnd;
    /**
     * The maxDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxDocuments;
    /**
     * Constructor method for document
     * @uses Document::setDateListStart()
     * @uses Document::setDateListEnd()
     * @uses Document::setMaxDocuments()
     * @param string $dateListStart
     * @param string $dateListEnd
     * @param int $maxDocuments
     */
    public function __construct($dateListStart = null, $dateListEnd = null, $maxDocuments = null)
    {
        $this
            ->setDateListStart($dateListStart)
            ->setDateListEnd($dateListEnd)
            ->setMaxDocuments($maxDocuments);
    }
    /**
     * Get dateListStart value
     * @return string|null
     */
    public function getDateListStart()
    {
        return $this->dateListStart;
    }
    /**
     * Set dateListStart value
     * @param string $dateListStart
     * @return \StructType\Document
     */
    public function setDateListStart($dateListStart = null)
    {
        // validation for constraint: minInclusive
        if ($dateListStart < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateListStart), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateListStart) && !is_string($dateListStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateListStart)), __LINE__);
        }
        $this->dateListStart = $dateListStart;
        return $this;
    }
    /**
     * Get dateListEnd value
     * @return string|null
     */
    public function getDateListEnd()
    {
        return $this->dateListEnd;
    }
    /**
     * Set dateListEnd value
     * @param string $dateListEnd
     * @return \StructType\Document
     */
    public function setDateListEnd($dateListEnd = null)
    {
        // validation for constraint: minInclusive
        if ($dateListEnd < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateListEnd), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateListEnd) && !is_string($dateListEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateListEnd)), __LINE__);
        }
        $this->dateListEnd = $dateListEnd;
        return $this;
    }
    /**
     * Get maxDocuments value
     * @return int|null
     */
    public function getMaxDocuments()
    {
        return $this->maxDocuments;
    }
    /**
     * Set maxDocuments value
     * @param int $maxDocuments
     * @return \StructType\Document
     */
    public function setMaxDocuments($maxDocuments = null)
    {
        // validation for constraint: int
        if (!is_null($maxDocuments) && !is_numeric($maxDocuments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxDocuments)), __LINE__);
        }
        $this->maxDocuments = $maxDocuments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
