<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deductibleGiftRecipient StructType
 * Meta informations extracted from the WSDL
 * - documentation: The deductibleGiftRecipient allows for an entity to have DGR status.
 * @subpackage Structs
 */
class DeductibleGiftRecipient extends AbstractStructBase
{
    /**
     * The DGRStatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DGRStatusCode;
    /**
     * The effectiveFrom
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveFrom defines the date from which a DGR staus is effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveFrom;
    /**
     * The effectiveTo
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveTo defines the date from which a DGR Status is no longer effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveTo;
    /**
     * Constructor method for deductibleGiftRecipient
     * @uses DeductibleGiftRecipient::setDGRStatusCode()
     * @uses DeductibleGiftRecipient::setEffectiveFrom()
     * @uses DeductibleGiftRecipient::setEffectiveTo()
     * @param string $dGRStatusCode
     * @param string $effectiveFrom
     * @param string $effectiveTo
     */
    public function __construct($dGRStatusCode = null, $effectiveFrom = null, $effectiveTo = null)
    {
        $this
            ->setDGRStatusCode($dGRStatusCode)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveTo($effectiveTo);
    }
    /**
     * Get DGRStatusCode value
     * @return string|null
     */
    public function getDGRStatusCode()
    {
        return $this->DGRStatusCode;
    }
    /**
     * Set DGRStatusCode value
     * @param string $dGRStatusCode
     * @return \StructType\DeductibleGiftRecipient
     */
    public function setDGRStatusCode($dGRStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($dGRStatusCode) && !is_string($dGRStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dGRStatusCode)), __LINE__);
        }
        $this->DGRStatusCode = $dGRStatusCode;
        return $this;
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\DeductibleGiftRecipient
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get effectiveTo value
     * @return string|null
     */
    public function getEffectiveTo()
    {
        return $this->effectiveTo;
    }
    /**
     * Set effectiveTo value
     * @param string $effectiveTo
     * @return \StructType\DeductibleGiftRecipient
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        $this->effectiveTo = $effectiveTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeductibleGiftRecipient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
