<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for debtorType StructType
 * @subpackage Structs
 */
class DebtorType extends AbstractStructBase
{
    /**
     * The account
     * @var \StructType\FssAccountType
     */
    public $account;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Business name, company name, etc
     * - maxLength: 200
     * @var string
     */
    public $name;
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The abnReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 99999999999999
     * - totalDigits: 13
     * @var int
     */
    public $abnReferenceNumber;
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * Constructor method for debtorType
     * @uses DebtorType::setAccount()
     * @uses DebtorType::setName()
     * @uses DebtorType::setAbn()
     * @uses DebtorType::setAbnReferenceNumber()
     * @uses DebtorType::setAddress()
     * @param \StructType\FssAccountType $account
     * @param string $name
     * @param string $abn
     * @param int $abnReferenceNumber
     * @param string $address
     */
    public function __construct(\StructType\FssAccountType $account = null, $name = null, $abn = null, $abnReferenceNumber = null, $address = null)
    {
        $this
            ->setAccount($account)
            ->setName($name)
            ->setAbn($abn)
            ->setAbnReferenceNumber($abnReferenceNumber)
            ->setAddress($address);
    }
    /**
     * Get account value
     * @return \StructType\FssAccountType|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\FssAccountType $account
     * @return \StructType\DebtorType
     */
    public function setAccount(\StructType\FssAccountType $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DebtorType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\DebtorType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get abnReferenceNumber value
     * @return int|null
     */
    public function getAbnReferenceNumber()
    {
        return $this->abnReferenceNumber;
    }
    /**
     * Set abnReferenceNumber value
     * @param int $abnReferenceNumber
     * @return \StructType\DebtorType
     */
    public function setAbnReferenceNumber($abnReferenceNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($abnReferenceNumber > 99999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999999999, "%s" given', $abnReferenceNumber), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($abnReferenceNumber) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abnReferenceNumber)) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 13 digits, "%d" given', strlen(substr($abnReferenceNumber, strpos($abnReferenceNumber, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($abnReferenceNumber) && !is_numeric($abnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($abnReferenceNumber)), __LINE__);
        }
        $this->abnReferenceNumber = $abnReferenceNumber;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $address
     * @return \StructType\DebtorType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($address)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $address, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebtorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
