<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerIdentifier StructType
 * @subpackage Structs
 */
class CustomerIdentifier extends AbstractStructBase
{
    /**
     * The customer
     * @var \StructType\AccountIdentifierType
     */
    public $customer;
    /**
     * The identifier
     * @var \StructType\Identifier
     */
    public $identifier;
    /**
     * Constructor method for customerIdentifier
     * @uses CustomerIdentifier::setCustomer()
     * @uses CustomerIdentifier::setIdentifier()
     * @param \StructType\AccountIdentifierType $customer
     * @param \StructType\Identifier $identifier
     */
    public function __construct(\StructType\AccountIdentifierType $customer = null, \StructType\Identifier $identifier = null)
    {
        $this
            ->setCustomer($customer)
            ->setIdentifier($identifier);
    }
    /**
     * Get customer value
     * @return \StructType\AccountIdentifierType|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\AccountIdentifierType $customer
     * @return \StructType\CustomerIdentifier
     */
    public function setCustomer(\StructType\AccountIdentifierType $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get identifier value
     * @return \StructType\Identifier|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param \StructType\Identifier $identifier
     * @return \StructType\CustomerIdentifier
     */
    public function setIdentifier(\StructType\Identifier $identifier = null)
    {
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
