<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contactPersonWithAddressType StructType
 * @subpackage Structs
 */
class ContactPersonWithAddressType extends ContactPersonType
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * Constructor method for contactPersonWithAddressType
     * @uses ContactPersonWithAddressType::setAddress()
     * @param string $address
     */
    public function __construct($address = null)
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $address
     * @return \StructType\ContactPersonWithAddressType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($address)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $address, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactPersonWithAddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
