<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contactPersonType StructType
 * @subpackage Structs
 */
class ContactPersonType extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonNameLodgeType
     */
    public $name;
    /**
     * The phoneNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\TelephoneNumberType
     */
    public $phoneNumber;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * Constructor method for contactPersonType
     * @uses ContactPersonType::setName()
     * @uses ContactPersonType::setPhoneNumber()
     * @uses ContactPersonType::setEmailAddress()
     * @param \StructType\PersonNameLodgeType $name
     * @param \StructType\TelephoneNumberType $phoneNumber
     * @param string $emailAddress
     */
    public function __construct(\StructType\PersonNameLodgeType $name = null, \StructType\TelephoneNumberType $phoneNumber = null, $emailAddress = null)
    {
        $this
            ->setName($name)
            ->setPhoneNumber($phoneNumber)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get name value
     * @return \StructType\PersonNameLodgeType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\PersonNameLodgeType $name
     * @return \StructType\ContactPersonType
     */
    public function setName(\StructType\PersonNameLodgeType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return \StructType\TelephoneNumberType|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param \StructType\TelephoneNumberType $phoneNumber
     * @return \StructType\ContactPersonType
     */
    public function setPhoneNumber(\StructType\TelephoneNumberType $phoneNumber = null)
    {
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \StructType\ContactPersonType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactPersonType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
