<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for companyType StructType
 * @subpackage Structs
 */
class CompanyType extends NameIndexEntityType
{
    /**
     * The officeholders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Officeholders
     */
    public $officeholders;
    /**
     * The shareholders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Shareholders
     */
    public $shareholders;
    /**
     * The businessNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\OutboundBusinessNameType[]
     */
    public $businessNames;
    /**
     * Constructor method for companyType
     * @uses CompanyType::setOfficeholders()
     * @uses CompanyType::setShareholders()
     * @uses CompanyType::setBusinessNames()
     * @param \StructType\Officeholders $officeholders
     * @param \StructType\Shareholders $shareholders
     * @param \StructType\OutboundBusinessNameType[] $businessNames
     */
    public function __construct(\StructType\Officeholders $officeholders = null, \StructType\Shareholders $shareholders = null, array $businessNames = array())
    {
        $this
            ->setOfficeholders($officeholders)
            ->setShareholders($shareholders)
            ->setBusinessNames($businessNames);
    }
    /**
     * Get officeholders value
     * @return \StructType\Officeholders|null
     */
    public function getOfficeholders()
    {
        return $this->officeholders;
    }
    /**
     * Set officeholders value
     * @param \StructType\Officeholders $officeholders
     * @return \StructType\CompanyType
     */
    public function setOfficeholders(\StructType\Officeholders $officeholders = null)
    {
        $this->officeholders = $officeholders;
        return $this;
    }
    /**
     * Get shareholders value
     * @return \StructType\Shareholders|null
     */
    public function getShareholders()
    {
        return $this->shareholders;
    }
    /**
     * Set shareholders value
     * @param \StructType\Shareholders $shareholders
     * @return \StructType\CompanyType
     */
    public function setShareholders(\StructType\Shareholders $shareholders = null)
    {
        $this->shareholders = $shareholders;
        return $this;
    }
    /**
     * Get businessNames value
     * @return \StructType\OutboundBusinessNameType[]|null
     */
    public function getBusinessNames()
    {
        return $this->businessNames;
    }
    /**
     * Set businessNames value
     * @throws \InvalidArgumentException
     * @param \StructType\OutboundBusinessNameType[] $businessNames
     * @return \StructType\CompanyType
     */
    public function setBusinessNames(array $businessNames = array())
    {
        foreach ($businessNames as $companyTypeBusinessNamesItem) {
            // validation for constraint: itemType
            if (!$companyTypeBusinessNamesItem instanceof \StructType\OutboundBusinessNameType) {
                throw new \InvalidArgumentException(sprintf('The businessNames property can only contain items of \StructType\OutboundBusinessNameType, "%s" given', is_object($companyTypeBusinessNamesItem) ? get_class($companyTypeBusinessNamesItem) : gettype($companyTypeBusinessNamesItem)), __LINE__);
            }
        }
        $this->businessNames = $businessNames;
        return $this;
    }
    /**
     * Add item to businessNames value
     * @throws \InvalidArgumentException
     * @param \StructType\OutboundBusinessNameType $item
     * @return \StructType\CompanyType
     */
    public function addToBusinessNames(\StructType\OutboundBusinessNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OutboundBusinessNameType) {
            throw new \InvalidArgumentException(sprintf('The businessNames property can only contain items of \StructType\OutboundBusinessNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->businessNames[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
