<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessNameIdentifierType StructType
 * @subpackage Structs
 */
class BusinessNameIdentifierType extends AbstractStructBase
{
    /**
     * The nniNumber
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $nniNumber;
    /**
     * The bnReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $bnReferenceNumber;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $name;
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * Constructor method for businessNameIdentifierType
     * @uses BusinessNameIdentifierType::setNniNumber()
     * @uses BusinessNameIdentifierType::setBnReferenceNumber()
     * @uses BusinessNameIdentifierType::setName()
     * @uses BusinessNameIdentifierType::setAbn()
     * @param int $nniNumber
     * @param string $bnReferenceNumber
     * @param string $name
     * @param string $abn
     */
    public function __construct($nniNumber = null, $bnReferenceNumber = null, $name = null, $abn = null)
    {
        $this
            ->setNniNumber($nniNumber)
            ->setBnReferenceNumber($bnReferenceNumber)
            ->setName($name)
            ->setAbn($abn);
    }
    /**
     * Get nniNumber value
     * @return int|null
     */
    public function getNniNumber()
    {
        return $this->nniNumber;
    }
    /**
     * Set nniNumber value
     * @param int $nniNumber
     * @return \StructType\BusinessNameIdentifierType
     */
    public function setNniNumber($nniNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($nniNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $nniNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($nniNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $nniNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($nniNumber) && !is_numeric($nniNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nniNumber)), __LINE__);
        }
        $this->nniNumber = $nniNumber;
        return $this;
    }
    /**
     * Get bnReferenceNumber value
     * @return string|null
     */
    public function getBnReferenceNumber()
    {
        return $this->bnReferenceNumber;
    }
    /**
     * Set bnReferenceNumber value
     * @param string $bnReferenceNumber
     * @return \StructType\BusinessNameIdentifierType
     */
    public function setBnReferenceNumber($bnReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) > 20) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($bnReferenceNumber) ? strlen($bnReferenceNumber) : count($bnReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) < 1) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bnReferenceNumber) && !is_string($bnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bnReferenceNumber)), __LINE__);
        }
        $this->bnReferenceNumber = $bnReferenceNumber;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\BusinessNameIdentifierType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\BusinessNameIdentifierType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessNameIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
