<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessEntityType StructType
 * @subpackage Structs
 */
class BusinessEntityType extends AbstractStructBase
{
    /**
     * The abrEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AbrEntityType
     */
    public $abrEntity;
    /**
     * The abnExemption
     * Meta informations extracted from the WSDL
     * - documentation: Xmas Island and Cocos Islands residents
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $abnExemption;
    /**
     * The individual
     * Meta informations extracted from the WSDL
     * - documentation: Sole TraderIndividual
     * @var \StructType\IndividualType
     */
    public $individual;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - documentation: CompanyPartnershipUnincorporateStructure
     * @var \StructType\OrganisationType
     */
    public $organisation;
    /**
     * The ownerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ownerType;
    /**
     * The associate
     * Meta informations extracted from the WSDL
     * - documentation: Partners for PartnershipsReps for Trusts etcVentures for Joint Venturers
     * - maxOccurs: 500
     * - minOccurs: 0
     * @var \StructType\AssociateType[]
     */
    public $associate;
    /**
     * The dateReview
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateReview;
    /**
     * Constructor method for businessEntityType
     * @uses BusinessEntityType::setAbrEntity()
     * @uses BusinessEntityType::setAbnExemption()
     * @uses BusinessEntityType::setIndividual()
     * @uses BusinessEntityType::setOrganisation()
     * @uses BusinessEntityType::setOwnerType()
     * @uses BusinessEntityType::setAssociate()
     * @uses BusinessEntityType::setDateReview()
     * @param \StructType\AbrEntityType $abrEntity
     * @param bool $abnExemption
     * @param \StructType\IndividualType $individual
     * @param \StructType\OrganisationType $organisation
     * @param string $ownerType
     * @param \StructType\AssociateType[] $associate
     * @param string $dateReview
     */
    public function __construct(\StructType\AbrEntityType $abrEntity = null, $abnExemption = null, \StructType\IndividualType $individual = null, \StructType\OrganisationType $organisation = null, $ownerType = null, array $associate = array(), $dateReview = null)
    {
        $this
            ->setAbrEntity($abrEntity)
            ->setAbnExemption($abnExemption)
            ->setIndividual($individual)
            ->setOrganisation($organisation)
            ->setOwnerType($ownerType)
            ->setAssociate($associate)
            ->setDateReview($dateReview);
    }
    /**
     * Get abrEntity value
     * @return \StructType\AbrEntityType|null
     */
    public function getAbrEntity()
    {
        return $this->abrEntity;
    }
    /**
     * Set abrEntity value
     * @param \StructType\AbrEntityType $abrEntity
     * @return \StructType\BusinessEntityType
     */
    public function setAbrEntity(\StructType\AbrEntityType $abrEntity = null)
    {
        $this->abrEntity = $abrEntity;
        return $this;
    }
    /**
     * Get abnExemption value
     * @return bool|null
     */
    public function getAbnExemption()
    {
        return $this->abnExemption;
    }
    /**
     * Set abnExemption value
     * @param bool $abnExemption
     * @return \StructType\BusinessEntityType
     */
    public function setAbnExemption($abnExemption = null)
    {
        // validation for constraint: pattern
        if (is_scalar($abnExemption) && !preg_match('/true/', $abnExemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($abnExemption, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($abnExemption) && !is_bool($abnExemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($abnExemption)), __LINE__);
        }
        $this->abnExemption = $abnExemption;
        return $this;
    }
    /**
     * Get individual value
     * @return \StructType\IndividualType|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\IndividualType $individual
     * @return \StructType\BusinessEntityType
     */
    public function setIndividual(\StructType\IndividualType $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\OrganisationType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\OrganisationType $organisation
     * @return \StructType\BusinessEntityType
     */
    public function setOrganisation(\StructType\OrganisationType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get ownerType value
     * @return string|null
     */
    public function getOwnerType()
    {
        return $this->ownerType;
    }
    /**
     * Set ownerType value
     * @uses \EnumType\OwnerType::valueIsValid()
     * @uses \EnumType\OwnerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ownerType
     * @return \StructType\BusinessEntityType
     */
    public function setOwnerType($ownerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OwnerType::valueIsValid($ownerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ownerType, implode(', ', \EnumType\OwnerType::getValidValues())), __LINE__);
        }
        $this->ownerType = $ownerType;
        return $this;
    }
    /**
     * Get associate value
     * @return \StructType\AssociateType[]|null
     */
    public function getAssociate()
    {
        return $this->associate;
    }
    /**
     * Set associate value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociateType[] $associate
     * @return \StructType\BusinessEntityType
     */
    public function setAssociate(array $associate = array())
    {
        foreach ($associate as $businessEntityTypeAssociateItem) {
            // validation for constraint: itemType
            if (!$businessEntityTypeAssociateItem instanceof \StructType\AssociateType) {
                throw new \InvalidArgumentException(sprintf('The associate property can only contain items of \StructType\AssociateType, "%s" given', is_object($businessEntityTypeAssociateItem) ? get_class($businessEntityTypeAssociateItem) : gettype($businessEntityTypeAssociateItem)), __LINE__);
            }
        }
        $this->associate = $associate;
        return $this;
    }
    /**
     * Add item to associate value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociateType $item
     * @return \StructType\BusinessEntityType
     */
    public function addToAssociate(\StructType\AssociateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssociateType) {
            throw new \InvalidArgumentException(sprintf('The associate property can only contain items of \StructType\AssociateType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->associate[] = $item;
        return $this;
    }
    /**
     * Get dateReview value
     * @return string|null
     */
    public function getDateReview()
    {
        return $this->dateReview;
    }
    /**
     * Set dateReview value
     * @param string $dateReview
     * @return \StructType\BusinessEntityType
     */
    public function setDateReview($dateReview = null)
    {
        // validation for constraint: minInclusive
        if ($dateReview < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateReview), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateReview) && !is_string($dateReview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateReview)), __LINE__);
        }
        $this->dateReview = $dateReview;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessEntityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
