<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessDocumentRequestHeaderType StructType
 * @subpackage Structs
 */
class BusinessDocumentRequestHeaderType extends AbstractStructBase
{
    /**
     * The messageType
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $messageType;
    /**
     * The messageReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $messageReferenceNumber;
    /**
     * The asicReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 99999999999
     * - minInclusive: 1
     * @var int
     */
    public $asicReferenceNumber;
    /**
     * The messageVersion
     * @var int
     */
    public $messageVersion;
    /**
     * The senderId
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $senderId;
    /**
     * The senderType
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $senderType;
    /**
     * The softwareInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SoftwareInformationType
     */
    public $softwareInformation;
    /**
     * The messageTimestamps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageTimestampsType
     */
    public $messageTimestamps;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttachmentsType
     */
    public $attachments;
    /**
     * Constructor method for businessDocumentRequestHeaderType
     * @uses BusinessDocumentRequestHeaderType::setMessageType()
     * @uses BusinessDocumentRequestHeaderType::setMessageReferenceNumber()
     * @uses BusinessDocumentRequestHeaderType::setAsicReferenceNumber()
     * @uses BusinessDocumentRequestHeaderType::setMessageVersion()
     * @uses BusinessDocumentRequestHeaderType::setSenderId()
     * @uses BusinessDocumentRequestHeaderType::setSenderType()
     * @uses BusinessDocumentRequestHeaderType::setSoftwareInformation()
     * @uses BusinessDocumentRequestHeaderType::setMessageTimestamps()
     * @uses BusinessDocumentRequestHeaderType::setAttachments()
     * @param string $messageType
     * @param string $messageReferenceNumber
     * @param int $asicReferenceNumber
     * @param int $messageVersion
     * @param string $senderId
     * @param string $senderType
     * @param \StructType\SoftwareInformationType $softwareInformation
     * @param \StructType\MessageTimestampsType $messageTimestamps
     * @param \StructType\AttachmentsType $attachments
     */
    public function __construct($messageType = null, $messageReferenceNumber = null, $asicReferenceNumber = null, $messageVersion = null, $senderId = null, $senderType = null, \StructType\SoftwareInformationType $softwareInformation = null, \StructType\MessageTimestampsType $messageTimestamps = null, \StructType\AttachmentsType $attachments = null)
    {
        $this
            ->setMessageType($messageType)
            ->setMessageReferenceNumber($messageReferenceNumber)
            ->setAsicReferenceNumber($asicReferenceNumber)
            ->setMessageVersion($messageVersion)
            ->setSenderId($senderId)
            ->setSenderType($senderType)
            ->setSoftwareInformation($softwareInformation)
            ->setMessageTimestamps($messageTimestamps)
            ->setAttachments($attachments);
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageType) && strlen($messageType) > 100) || (is_array($messageType) && count($messageType) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($messageType) ? strlen($messageType) : count($messageType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageType) && strlen($messageType) < 1) || (is_array($messageType) && count($messageType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get messageReferenceNumber value
     * @return string|null
     */
    public function getMessageReferenceNumber()
    {
        return $this->messageReferenceNumber;
    }
    /**
     * Set messageReferenceNumber value
     * @param string $messageReferenceNumber
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setMessageReferenceNumber($messageReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageReferenceNumber) && strlen($messageReferenceNumber) > 50) || (is_array($messageReferenceNumber) && count($messageReferenceNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($messageReferenceNumber) ? strlen($messageReferenceNumber) : count($messageReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageReferenceNumber) && strlen($messageReferenceNumber) < 1) || (is_array($messageReferenceNumber) && count($messageReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageReferenceNumber) && !is_string($messageReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageReferenceNumber)), __LINE__);
        }
        $this->messageReferenceNumber = $messageReferenceNumber;
        return $this;
    }
    /**
     * Get asicReferenceNumber value
     * @return int|null
     */
    public function getAsicReferenceNumber()
    {
        return $this->asicReferenceNumber;
    }
    /**
     * Set asicReferenceNumber value
     * @param int $asicReferenceNumber
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setAsicReferenceNumber($asicReferenceNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($asicReferenceNumber > 99999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999999, "%s" given', $asicReferenceNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($asicReferenceNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $asicReferenceNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($asicReferenceNumber) && !is_numeric($asicReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($asicReferenceNumber)), __LINE__);
        }
        $this->asicReferenceNumber = $asicReferenceNumber;
        return $this;
    }
    /**
     * Get messageVersion value
     * @return int|null
     */
    public function getMessageVersion()
    {
        return $this->messageVersion;
    }
    /**
     * Set messageVersion value
     * @param int $messageVersion
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setMessageVersion($messageVersion = null)
    {
        // validation for constraint: int
        if (!is_null($messageVersion) && !is_numeric($messageVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageVersion)), __LINE__);
        }
        $this->messageVersion = $messageVersion;
        return $this;
    }
    /**
     * Get senderId value
     * @return string|null
     */
    public function getSenderId()
    {
        return $this->senderId;
    }
    /**
     * Set senderId value
     * @param string $senderId
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setSenderId($senderId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($senderId) && strlen($senderId) > 50) || (is_array($senderId) && count($senderId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($senderId) ? strlen($senderId) : count($senderId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($senderId) && strlen($senderId) < 1) || (is_array($senderId) && count($senderId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($senderId) && !is_string($senderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderId)), __LINE__);
        }
        $this->senderId = $senderId;
        return $this;
    }
    /**
     * Get senderType value
     * @return string|null
     */
    public function getSenderType()
    {
        return $this->senderType;
    }
    /**
     * Set senderType value
     * @param string $senderType
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setSenderType($senderType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($senderType) && strlen($senderType) > 50) || (is_array($senderType) && count($senderType) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($senderType) ? strlen($senderType) : count($senderType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($senderType) && strlen($senderType) < 1) || (is_array($senderType) && count($senderType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($senderType) && !is_string($senderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderType)), __LINE__);
        }
        $this->senderType = $senderType;
        return $this;
    }
    /**
     * Get softwareInformation value
     * @return \StructType\SoftwareInformationType|null
     */
    public function getSoftwareInformation()
    {
        return $this->softwareInformation;
    }
    /**
     * Set softwareInformation value
     * @param \StructType\SoftwareInformationType $softwareInformation
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setSoftwareInformation(\StructType\SoftwareInformationType $softwareInformation = null)
    {
        $this->softwareInformation = $softwareInformation;
        return $this;
    }
    /**
     * Get messageTimestamps value
     * @return \StructType\MessageTimestampsType|null
     */
    public function getMessageTimestamps()
    {
        return $this->messageTimestamps;
    }
    /**
     * Set messageTimestamps value
     * @param \StructType\MessageTimestampsType $messageTimestamps
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setMessageTimestamps(\StructType\MessageTimestampsType $messageTimestamps = null)
    {
        $this->messageTimestamps = $messageTimestamps;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentsType|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\AttachmentsType $attachments
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public function setAttachments(\StructType\AttachmentsType $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessDocumentRequestHeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
