<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for business StructType
 * @subpackage Structs
 */
class Business extends BusinessEntityType
{
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $endDate;
    /**
     * The agentAppointed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $agentAppointed;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - documentation: CompanyPartnershipUnincorporateStructure
     * @var \StructType\NameIndexEntityType
     */
    public $organisation;
    /**
     * The person
     * Meta informations extracted from the WSDL
     * - documentation: Sole TraderIndividual
     * @var \StructType\IndividualType
     */
    public $person;
    /**
     * Constructor method for business
     * @uses Business::setStartDate()
     * @uses Business::setEndDate()
     * @uses Business::setAgentAppointed()
     * @uses Business::setOrganisation()
     * @uses Business::setPerson()
     * @param string $startDate
     * @param string $endDate
     * @param bool $agentAppointed
     * @param \StructType\NameIndexEntityType $organisation
     * @param \StructType\IndividualType $person
     */
    public function __construct($startDate = null, $endDate = null, $agentAppointed = null, \StructType\NameIndexEntityType $organisation = null, \StructType\IndividualType $person = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAgentAppointed($agentAppointed)
            ->setOrganisation($organisation)
            ->setPerson($person);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Business
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: minInclusive
        if ($startDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Business
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: minInclusive
        if ($endDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get agentAppointed value
     * @return bool|null
     */
    public function getAgentAppointed()
    {
        return $this->agentAppointed;
    }
    /**
     * Set agentAppointed value
     * @param bool $agentAppointed
     * @return \StructType\Business
     */
    public function setAgentAppointed($agentAppointed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($agentAppointed) && !preg_match('/true/', $agentAppointed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($agentAppointed, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($agentAppointed) && !is_bool($agentAppointed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($agentAppointed)), __LINE__);
        }
        $this->agentAppointed = $agentAppointed;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\NameIndexEntityType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\NameIndexEntityType $organisation
     * @return \StructType\Business
     */
    public function setOrganisation(\StructType\NameIndexEntityType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get person value
     * @return \StructType\IndividualType|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param \StructType\IndividualType $person
     * @return \StructType\Business
     */
    public function setPerson(\StructType\IndividualType $person = null)
    {
        $this->person = $person;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Business
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
