<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bnRenewalFormType StructType
 * Meta informations extracted from the WSDL
 * - documentation: BN Renewal Form definition
 * @subpackage Structs
 */
class BnRenewalFormType extends AbstractStructBase
{
    /**
     * The accountNumber
     * Meta informations extracted from the WSDL
     * - documentation: Account number of the Business name
     * - maxInclusive: 99999999999
     * - minInclusive: 1
     * @var int
     */
    public $accountNumber;
    /**
     * The ABN
     * Meta informations extracted from the WSDL
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $ABN;
    /**
     * The transactionId
     * Meta informations extracted from the WSDL
     * - documentation: TransactionId for the BN renewal request. NOT IN CURRENT IMPLEMENTATION.
     * - maxLength: 15
     * @var string
     */
    public $transactionId;
    /**
     * The businessName
     * Meta informations extracted from the WSDL
     * - documentation: Business name
     * @var \StructType\DistinguishedNameType
     */
    public $businessName;
    /**
     * The term
     * Meta informations extracted from the WSDL
     * - documentation: The duration of the next registration period for the nominated business name. It can be one or three years.
     * @var string
     */
    public $term;
    /**
     * The paymentType
     * Meta informations extracted from the WSDL
     * - documentation: Specify the payment option. Currently this is restricted to invoicing (INV) to the BN account only.
     * @var string
     */
    public $paymentType;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - documentation: Contact email address | email address
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * The signatory
     * Meta informations extracted from the WSDL
     * - documentation: ~ExternalMandatory~
     * @var \StructType\SignatoryType
     */
    public $signatory;
    /**
     * Constructor method for bnRenewalFormType
     * @uses BnRenewalFormType::setAccountNumber()
     * @uses BnRenewalFormType::setABN()
     * @uses BnRenewalFormType::setTransactionId()
     * @uses BnRenewalFormType::setBusinessName()
     * @uses BnRenewalFormType::setTerm()
     * @uses BnRenewalFormType::setPaymentType()
     * @uses BnRenewalFormType::setEmailAddress()
     * @uses BnRenewalFormType::setSignatory()
     * @param int $accountNumber
     * @param string $aBN
     * @param string $transactionId
     * @param \StructType\DistinguishedNameType $businessName
     * @param string $term
     * @param string $paymentType
     * @param string $emailAddress
     * @param \StructType\SignatoryType $signatory
     */
    public function __construct($accountNumber = null, $aBN = null, $transactionId = null, \StructType\DistinguishedNameType $businessName = null, $term = null, $paymentType = null, $emailAddress = null, \StructType\SignatoryType $signatory = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setABN($aBN)
            ->setTransactionId($transactionId)
            ->setBusinessName($businessName)
            ->setTerm($term)
            ->setPaymentType($paymentType)
            ->setEmailAddress($emailAddress)
            ->setSignatory($signatory);
    }
    /**
     * Get accountNumber value
     * @return int|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param int $accountNumber
     * @return \StructType\BnRenewalFormType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($accountNumber > 99999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999999, "%s" given', $accountNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($accountNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $accountNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($accountNumber) && !is_numeric($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ABN value
     * @return string|null
     */
    public function getABN()
    {
        return $this->ABN;
    }
    /**
     * Set ABN value
     * @param string $aBN
     * @return \StructType\BnRenewalFormType
     */
    public function setABN($aBN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aBN) && strlen($aBN) > 11) || (is_array($aBN) && count($aBN) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($aBN) ? strlen($aBN) : count($aBN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($aBN) && strlen($aBN) < 11) || (is_array($aBN) && count($aBN) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($aBN) && !preg_match('/([0-9]{11})/', $aBN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($aBN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aBN) && !is_string($aBN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aBN)), __LINE__);
        }
        $this->ABN = $aBN;
        return $this;
    }
    /**
     * Get transactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param string $transactionId
     * @return \StructType\BnRenewalFormType
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transactionId) && strlen($transactionId) > 15) || (is_array($transactionId) && count($transactionId) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($transactionId) ? strlen($transactionId) : count($transactionId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get businessName value
     * @return \StructType\DistinguishedNameType|null
     */
    public function getBusinessName()
    {
        return $this->businessName;
    }
    /**
     * Set businessName value
     * @param \StructType\DistinguishedNameType $businessName
     * @return \StructType\BnRenewalFormType
     */
    public function setBusinessName(\StructType\DistinguishedNameType $businessName = null)
    {
        $this->businessName = $businessName;
        return $this;
    }
    /**
     * Get term value
     * @return string|null
     */
    public function getTerm()
    {
        return $this->term;
    }
    /**
     * Set term value
     * @uses \EnumType\TermType::valueIsValid()
     * @uses \EnumType\TermType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $term
     * @return \StructType\BnRenewalFormType
     */
    public function setTerm($term = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TermType::valueIsValid($term)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $term, implode(', ', \EnumType\TermType::getValidValues())), __LINE__);
        }
        $this->term = $term;
        return $this;
    }
    /**
     * Get paymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @uses \EnumType\PaymentMethodType::valueIsValid()
     * @uses \EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \StructType\BnRenewalFormType
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentMethodType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentType, implode(', ', \EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \StructType\BnRenewalFormType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get signatory value
     * @return \StructType\SignatoryType|null
     */
    public function getSignatory()
    {
        return $this->signatory;
    }
    /**
     * Set signatory value
     * @param \StructType\SignatoryType $signatory
     * @return \StructType\BnRenewalFormType
     */
    public function setSignatory(\StructType\SignatoryType $signatory = null)
    {
        $this->signatory = $signatory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BnRenewalFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
