<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bnLodgeFormType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Form BZ1 definition
 * @subpackage Structs
 */
class BnLodgeFormType extends AbstractStructBase
{
    /**
     * The name
     * @var \StructType\DistinguishedNameType
     */
    public $name;
    /**
     * The term
     * @var string
     */
    public $term;
    /**
     * The dateRenewal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRenewal;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\AddressLodgeType[]
     */
    public $address;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - documentation: email address
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * The smsNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $smsNumber;
    /**
     * The businessEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessEntityLodgeType
     */
    public $businessEntity;
    /**
     * The transferKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transferKey;
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactPersonType
     */
    public $contact;
    /**
     * The signatory
     * @var \StructType\SignatoryType
     */
    public $signatory;
    /**
     * Constructor method for bnLodgeFormType
     * @uses BnLodgeFormType::setName()
     * @uses BnLodgeFormType::setTerm()
     * @uses BnLodgeFormType::setDateRenewal()
     * @uses BnLodgeFormType::setAddress()
     * @uses BnLodgeFormType::setEmailAddress()
     * @uses BnLodgeFormType::setSmsNumber()
     * @uses BnLodgeFormType::setBusinessEntity()
     * @uses BnLodgeFormType::setTransferKey()
     * @uses BnLodgeFormType::setContact()
     * @uses BnLodgeFormType::setSignatory()
     * @param \StructType\DistinguishedNameType $name
     * @param string $term
     * @param string $dateRenewal
     * @param \StructType\AddressLodgeType[] $address
     * @param string $emailAddress
     * @param string $smsNumber
     * @param \StructType\BusinessEntityLodgeType $businessEntity
     * @param string $transferKey
     * @param \StructType\ContactPersonType $contact
     * @param \StructType\SignatoryType $signatory
     */
    public function __construct(\StructType\DistinguishedNameType $name = null, $term = null, $dateRenewal = null, array $address = array(), $emailAddress = null, $smsNumber = null, \StructType\BusinessEntityLodgeType $businessEntity = null, $transferKey = null, \StructType\ContactPersonType $contact = null, \StructType\SignatoryType $signatory = null)
    {
        $this
            ->setName($name)
            ->setTerm($term)
            ->setDateRenewal($dateRenewal)
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setSmsNumber($smsNumber)
            ->setBusinessEntity($businessEntity)
            ->setTransferKey($transferKey)
            ->setContact($contact)
            ->setSignatory($signatory);
    }
    /**
     * Get name value
     * @return \StructType\DistinguishedNameType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\DistinguishedNameType $name
     * @return \StructType\BnLodgeFormType
     */
    public function setName(\StructType\DistinguishedNameType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get term value
     * @return string|null
     */
    public function getTerm()
    {
        return $this->term;
    }
    /**
     * Set term value
     * @uses \EnumType\TermType::valueIsValid()
     * @uses \EnumType\TermType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $term
     * @return \StructType\BnLodgeFormType
     */
    public function setTerm($term = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TermType::valueIsValid($term)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $term, implode(', ', \EnumType\TermType::getValidValues())), __LINE__);
        }
        $this->term = $term;
        return $this;
    }
    /**
     * Get dateRenewal value
     * @return string|null
     */
    public function getDateRenewal()
    {
        return $this->dateRenewal;
    }
    /**
     * Set dateRenewal value
     * @param string $dateRenewal
     * @return \StructType\BnLodgeFormType
     */
    public function setDateRenewal($dateRenewal = null)
    {
        // validation for constraint: minInclusive
        if ($dateRenewal < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRenewal), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRenewal) && !is_string($dateRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRenewal)), __LINE__);
        }
        $this->dateRenewal = $dateRenewal;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\AddressLodgeType[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressLodgeType[] $address
     * @return \StructType\BnLodgeFormType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $bnLodgeFormTypeAddressItem) {
            // validation for constraint: itemType
            if (!$bnLodgeFormTypeAddressItem instanceof \StructType\AddressLodgeType) {
                throw new \InvalidArgumentException(sprintf('The address property can only contain items of \StructType\AddressLodgeType, "%s" given', is_object($bnLodgeFormTypeAddressItem) ? get_class($bnLodgeFormTypeAddressItem) : gettype($bnLodgeFormTypeAddressItem)), __LINE__);
            }
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressLodgeType $item
     * @return \StructType\BnLodgeFormType
     */
    public function addToAddress(\StructType\AddressLodgeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressLodgeType) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of \StructType\AddressLodgeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \StructType\BnLodgeFormType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get smsNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmsNumber()
    {
        return isset($this->smsNumber) ? $this->smsNumber : null;
    }
    /**
     * Set smsNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smsNumber
     * @return \StructType\BnLodgeFormType
     */
    public function setSmsNumber($smsNumber = null)
    {
        // validation for constraint: string
        if (!is_null($smsNumber) && !is_string($smsNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smsNumber)), __LINE__);
        }
        if (is_null($smsNumber) || (is_array($smsNumber) && empty($smsNumber))) {
            unset($this->smsNumber);
        } else {
            $this->smsNumber = $smsNumber;
        }
        return $this;
    }
    /**
     * Get businessEntity value
     * @return \StructType\BusinessEntityLodgeType|null
     */
    public function getBusinessEntity()
    {
        return $this->businessEntity;
    }
    /**
     * Set businessEntity value
     * @param \StructType\BusinessEntityLodgeType $businessEntity
     * @return \StructType\BnLodgeFormType
     */
    public function setBusinessEntity(\StructType\BusinessEntityLodgeType $businessEntity = null)
    {
        $this->businessEntity = $businessEntity;
        return $this;
    }
    /**
     * Get transferKey value
     * @return string|null
     */
    public function getTransferKey()
    {
        return $this->transferKey;
    }
    /**
     * Set transferKey value
     * @param string $transferKey
     * @return \StructType\BnLodgeFormType
     */
    public function setTransferKey($transferKey = null)
    {
        // validation for constraint: string
        if (!is_null($transferKey) && !is_string($transferKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transferKey)), __LINE__);
        }
        $this->transferKey = $transferKey;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\ContactPersonType|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\ContactPersonType $contact
     * @return \StructType\BnLodgeFormType
     */
    public function setContact(\StructType\ContactPersonType $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get signatory value
     * @return \StructType\SignatoryType|null
     */
    public function getSignatory()
    {
        return $this->signatory;
    }
    /**
     * Set signatory value
     * @param \StructType\SignatoryType $signatory
     * @return \StructType\BnLodgeFormType
     */
    public function setSignatory(\StructType\SignatoryType $signatory = null)
    {
        $this->signatory = $signatory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BnLodgeFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
