<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bnExtractRequestType StructType
 * @subpackage Structs
 */
class BnExtractRequestType extends AbstractStructBase
{
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - documentation: ABN for the business name organisation holder
     * - maxLength: 20
     * @var string
     */
    public $abn;
    /**
     * The orgNumber
     * Meta informations extracted from the WSDL
     * - documentation: Asic Identifier for the business name organisation holder
     * @var string
     */
    public $orgNumber;
    /**
     * The nniNumber
     * Meta informations extracted from the WSDL
     * - documentation: Asic Identifier for the business name
     * @var string
     */
    public $nniNumber;
    /**
     * The bnReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $bnReferenceNumber;
    /**
     * The stateTerritory
     * @var \StructType\StateTerritory
     */
    public $stateTerritory;
    /**
     * The summaryDetailsOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $summaryDetailsOnly;
    /**
     * The maxDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxDocuments;
    /**
     * The showHistory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showHistory;
    /**
     * Constructor method for bnExtractRequestType
     * @uses BnExtractRequestType::setAbn()
     * @uses BnExtractRequestType::setOrgNumber()
     * @uses BnExtractRequestType::setNniNumber()
     * @uses BnExtractRequestType::setBnReferenceNumber()
     * @uses BnExtractRequestType::setStateTerritory()
     * @uses BnExtractRequestType::setSummaryDetailsOnly()
     * @uses BnExtractRequestType::setMaxDocuments()
     * @uses BnExtractRequestType::setShowHistory()
     * @param string $abn
     * @param string $orgNumber
     * @param string $nniNumber
     * @param string $bnReferenceNumber
     * @param \StructType\StateTerritory $stateTerritory
     * @param bool $summaryDetailsOnly
     * @param int $maxDocuments
     * @param bool $showHistory
     */
    public function __construct($abn = null, $orgNumber = null, $nniNumber = null, $bnReferenceNumber = null, \StructType\StateTerritory $stateTerritory = null, $summaryDetailsOnly = null, $maxDocuments = null, $showHistory = null)
    {
        $this
            ->setAbn($abn)
            ->setOrgNumber($orgNumber)
            ->setNniNumber($nniNumber)
            ->setBnReferenceNumber($bnReferenceNumber)
            ->setStateTerritory($stateTerritory)
            ->setSummaryDetailsOnly($summaryDetailsOnly)
            ->setMaxDocuments($maxDocuments)
            ->setShowHistory($showHistory);
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\BnExtractRequestType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 20) || (is_array($abn) && count($abn) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get orgNumber value
     * @return string|null
     */
    public function getOrgNumber()
    {
        return $this->orgNumber;
    }
    /**
     * Set orgNumber value
     * @param string $orgNumber
     * @return \StructType\BnExtractRequestType
     */
    public function setOrgNumber($orgNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orgNumber) && !is_string($orgNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgNumber)), __LINE__);
        }
        $this->orgNumber = $orgNumber;
        return $this;
    }
    /**
     * Get nniNumber value
     * @return string|null
     */
    public function getNniNumber()
    {
        return $this->nniNumber;
    }
    /**
     * Set nniNumber value
     * @param string $nniNumber
     * @return \StructType\BnExtractRequestType
     */
    public function setNniNumber($nniNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nniNumber) && !is_string($nniNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nniNumber)), __LINE__);
        }
        $this->nniNumber = $nniNumber;
        return $this;
    }
    /**
     * Get bnReferenceNumber value
     * @return string|null
     */
    public function getBnReferenceNumber()
    {
        return $this->bnReferenceNumber;
    }
    /**
     * Set bnReferenceNumber value
     * @param string $bnReferenceNumber
     * @return \StructType\BnExtractRequestType
     */
    public function setBnReferenceNumber($bnReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) > 20) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($bnReferenceNumber) ? strlen($bnReferenceNumber) : count($bnReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) < 1) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bnReferenceNumber) && !is_string($bnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bnReferenceNumber)), __LINE__);
        }
        $this->bnReferenceNumber = $bnReferenceNumber;
        return $this;
    }
    /**
     * Get stateTerritory value
     * @return \StructType\StateTerritory|null
     */
    public function getStateTerritory()
    {
        return $this->stateTerritory;
    }
    /**
     * Set stateTerritory value
     * @param \StructType\StateTerritory $stateTerritory
     * @return \StructType\BnExtractRequestType
     */
    public function setStateTerritory(\StructType\StateTerritory $stateTerritory = null)
    {
        $this->stateTerritory = $stateTerritory;
        return $this;
    }
    /**
     * Get summaryDetailsOnly value
     * @return bool|null
     */
    public function getSummaryDetailsOnly()
    {
        return $this->summaryDetailsOnly;
    }
    /**
     * Set summaryDetailsOnly value
     * @param bool $summaryDetailsOnly
     * @return \StructType\BnExtractRequestType
     */
    public function setSummaryDetailsOnly($summaryDetailsOnly = null)
    {
        // validation for constraint: pattern
        if (is_scalar($summaryDetailsOnly) && !preg_match('/true/', $summaryDetailsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($summaryDetailsOnly, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($summaryDetailsOnly) && !is_bool($summaryDetailsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($summaryDetailsOnly)), __LINE__);
        }
        $this->summaryDetailsOnly = $summaryDetailsOnly;
        return $this;
    }
    /**
     * Get maxDocuments value
     * @return int|null
     */
    public function getMaxDocuments()
    {
        return $this->maxDocuments;
    }
    /**
     * Set maxDocuments value
     * @param int $maxDocuments
     * @return \StructType\BnExtractRequestType
     */
    public function setMaxDocuments($maxDocuments = null)
    {
        // validation for constraint: int
        if (!is_null($maxDocuments) && !is_numeric($maxDocuments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxDocuments)), __LINE__);
        }
        $this->maxDocuments = $maxDocuments;
        return $this;
    }
    /**
     * Get showHistory value
     * @return bool|null
     */
    public function getShowHistory()
    {
        return $this->showHistory;
    }
    /**
     * Set showHistory value
     * @param bool $showHistory
     * @return \StructType\BnExtractRequestType
     */
    public function setShowHistory($showHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($showHistory) && !is_bool($showHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($showHistory)), __LINE__);
        }
        $this->showHistory = $showHistory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BnExtractRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
