<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for billingAddress StructType
 * @subpackage Structs
 */
class BillingAddress extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The addressType
     * @var string
     */
    public $addressType;
    /**
     * The returnToSenderIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $returnToSenderIndicator;
    /**
     * The removeAddress
     * Meta informations extracted from the WSDL
     * - documentation: To be provided with address type
     * - minOccurs: 0
     * @var bool
     */
    public $removeAddress;
    /**
     * Constructor method for billingAddress
     * @uses BillingAddress::setAddress()
     * @uses BillingAddress::setAddressType()
     * @uses BillingAddress::setReturnToSenderIndicator()
     * @uses BillingAddress::setRemoveAddress()
     * @param string $address
     * @param string $addressType
     * @param bool $returnToSenderIndicator
     * @param bool $removeAddress
     */
    public function __construct($address = null, $addressType = null, $returnToSenderIndicator = null, $removeAddress = null)
    {
        $this
            ->setAddress($address)
            ->setAddressType($addressType)
            ->setReturnToSenderIndicator($returnToSenderIndicator)
            ->setRemoveAddress($removeAddress);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $address
     * @return \StructType\BillingAddress
     */
    public function setAddress($address = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($address)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $address, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get addressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->addressType;
    }
    /**
     * Set addressType value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressType
     * @return \StructType\BillingAddress
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($addressType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $addressType, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->addressType = $addressType;
        return $this;
    }
    /**
     * Get returnToSenderIndicator value
     * @return bool|null
     */
    public function getReturnToSenderIndicator()
    {
        return $this->returnToSenderIndicator;
    }
    /**
     * Set returnToSenderIndicator value
     * @param bool $returnToSenderIndicator
     * @return \StructType\BillingAddress
     */
    public function setReturnToSenderIndicator($returnToSenderIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnToSenderIndicator) && !is_bool($returnToSenderIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnToSenderIndicator)), __LINE__);
        }
        $this->returnToSenderIndicator = $returnToSenderIndicator;
        return $this;
    }
    /**
     * Get removeAddress value
     * @return bool|null
     */
    public function getRemoveAddress()
    {
        return $this->removeAddress;
    }
    /**
     * Set removeAddress value
     * @param bool $removeAddress
     * @return \StructType\BillingAddress
     */
    public function setRemoveAddress($removeAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeAddress) && !is_bool($removeAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($removeAddress)), __LINE__);
        }
        $this->removeAddress = $removeAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
