<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for baseNniEntityType StructType
 * @subpackage Structs
 */
class BaseNniEntityType extends AbstractStructBase
{
    /**
     * The identifier
     * @var \StructType\IdentifierType
     */
    public $identifier;
    /**
     * The bnReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $bnReferenceNumber;
    /**
     * The name
     * @var \StructType\DistinguishedNameType
     */
    public $name;
    /**
     * The type
     * @var \StructType\NniTypeType
     */
    public $type;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Companies
     * - minOccurs: 0
     * @var \StructType\ClassType
     */
    public $class;
    /**
     * The subClass
     * Meta informations extracted from the WSDL
     * - documentation: Companies
     * - minOccurs: 0
     * @var \StructType\ClassType
     */
    public $subClass;
    /**
     * The status
     * @var \StructType\StatusType
     */
    public $status;
    /**
     * The incorporationState
     * Meta informations extracted from the WSDL
     * - documentation: Companies
     * - minOccurs: 0
     * @var string
     */
    public $incorporationState;
    /**
     * The placeOfIncorporation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Foreign Companies
     * - maxLength: 30
     * @var string
     */
    public $placeOfIncorporation;
    /**
     * The previousStateTerritory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PreviousStateTerritoryType
     */
    public $previousStateTerritory;
    /**
     * The dateRegistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRegistered;
    /**
     * The dateRenewal
     * Meta informations extracted from the WSDL
     * - documentation: Business Names
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRenewal;
    /**
     * The dateDeregistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateDeregistered;
    /**
     * The dateReview
     * Meta informations extracted from the WSDL
     * - documentation: Companies
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateReview;
    /**
     * The jurisdiction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 80
     * @var string
     */
    public $jurisdiction;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $address;
    /**
     * The formerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var \StructType\FormerName[]
     */
    public $formerName;
    /**
     * The recentDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var \StructType\DocumentType[]
     */
    public $recentDocument;
    /**
     * Constructor method for baseNniEntityType
     * @uses BaseNniEntityType::setIdentifier()
     * @uses BaseNniEntityType::setBnReferenceNumber()
     * @uses BaseNniEntityType::setName()
     * @uses BaseNniEntityType::setType()
     * @uses BaseNniEntityType::setClass()
     * @uses BaseNniEntityType::setSubClass()
     * @uses BaseNniEntityType::setStatus()
     * @uses BaseNniEntityType::setIncorporationState()
     * @uses BaseNniEntityType::setPlaceOfIncorporation()
     * @uses BaseNniEntityType::setPreviousStateTerritory()
     * @uses BaseNniEntityType::setDateRegistered()
     * @uses BaseNniEntityType::setDateRenewal()
     * @uses BaseNniEntityType::setDateDeregistered()
     * @uses BaseNniEntityType::setDateReview()
     * @uses BaseNniEntityType::setJurisdiction()
     * @uses BaseNniEntityType::setAddress()
     * @uses BaseNniEntityType::setFormerName()
     * @uses BaseNniEntityType::setRecentDocument()
     * @param \StructType\IdentifierType $identifier
     * @param string $bnReferenceNumber
     * @param \StructType\DistinguishedNameType $name
     * @param \StructType\NniTypeType $type
     * @param \StructType\ClassType $class
     * @param \StructType\ClassType $subClass
     * @param \StructType\StatusType $status
     * @param string $incorporationState
     * @param string $placeOfIncorporation
     * @param \StructType\PreviousStateTerritoryType $previousStateTerritory
     * @param string $dateRegistered
     * @param string $dateRenewal
     * @param string $dateDeregistered
     * @param string $dateReview
     * @param string $jurisdiction
     * @param string[] $address
     * @param \StructType\FormerName[] $formerName
     * @param \StructType\DocumentType[] $recentDocument
     */
    public function __construct(\StructType\IdentifierType $identifier = null, $bnReferenceNumber = null, \StructType\DistinguishedNameType $name = null, \StructType\NniTypeType $type = null, \StructType\ClassType $class = null, \StructType\ClassType $subClass = null, \StructType\StatusType $status = null, $incorporationState = null, $placeOfIncorporation = null, \StructType\PreviousStateTerritoryType $previousStateTerritory = null, $dateRegistered = null, $dateRenewal = null, $dateDeregistered = null, $dateReview = null, $jurisdiction = null, array $address = array(), array $formerName = array(), array $recentDocument = array())
    {
        $this
            ->setIdentifier($identifier)
            ->setBnReferenceNumber($bnReferenceNumber)
            ->setName($name)
            ->setType($type)
            ->setClass($class)
            ->setSubClass($subClass)
            ->setStatus($status)
            ->setIncorporationState($incorporationState)
            ->setPlaceOfIncorporation($placeOfIncorporation)
            ->setPreviousStateTerritory($previousStateTerritory)
            ->setDateRegistered($dateRegistered)
            ->setDateRenewal($dateRenewal)
            ->setDateDeregistered($dateDeregistered)
            ->setDateReview($dateReview)
            ->setJurisdiction($jurisdiction)
            ->setAddress($address)
            ->setFormerName($formerName)
            ->setRecentDocument($recentDocument);
    }
    /**
     * Get identifier value
     * @return \StructType\IdentifierType|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param \StructType\IdentifierType $identifier
     * @return \StructType\BaseNniEntityType
     */
    public function setIdentifier(\StructType\IdentifierType $identifier = null)
    {
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get bnReferenceNumber value
     * @return string|null
     */
    public function getBnReferenceNumber()
    {
        return $this->bnReferenceNumber;
    }
    /**
     * Set bnReferenceNumber value
     * @param string $bnReferenceNumber
     * @return \StructType\BaseNniEntityType
     */
    public function setBnReferenceNumber($bnReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) > 20) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($bnReferenceNumber) ? strlen($bnReferenceNumber) : count($bnReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) < 1) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bnReferenceNumber) && !is_string($bnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bnReferenceNumber)), __LINE__);
        }
        $this->bnReferenceNumber = $bnReferenceNumber;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\DistinguishedNameType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\DistinguishedNameType $name
     * @return \StructType\BaseNniEntityType
     */
    public function setName(\StructType\DistinguishedNameType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return \StructType\NniTypeType|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param \StructType\NniTypeType $type
     * @return \StructType\BaseNniEntityType
     */
    public function setType(\StructType\NniTypeType $type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\ClassType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\ClassType $class
     * @return \StructType\BaseNniEntityType
     */
    public function setClass(\StructType\ClassType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get subClass value
     * @return \StructType\ClassType|null
     */
    public function getSubClass()
    {
        return $this->subClass;
    }
    /**
     * Set subClass value
     * @param \StructType\ClassType $subClass
     * @return \StructType\BaseNniEntityType
     */
    public function setSubClass(\StructType\ClassType $subClass = null)
    {
        $this->subClass = $subClass;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\StatusType|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\StatusType $status
     * @return \StructType\BaseNniEntityType
     */
    public function setStatus(\StructType\StatusType $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get incorporationState value
     * @return string|null
     */
    public function getIncorporationState()
    {
        return $this->incorporationState;
    }
    /**
     * Set incorporationState value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incorporationState
     * @return \StructType\BaseNniEntityType
     */
    public function setIncorporationState($incorporationState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($incorporationState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $incorporationState, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->incorporationState = $incorporationState;
        return $this;
    }
    /**
     * Get placeOfIncorporation value
     * @return string|null
     */
    public function getPlaceOfIncorporation()
    {
        return $this->placeOfIncorporation;
    }
    /**
     * Set placeOfIncorporation value
     * @param string $placeOfIncorporation
     * @return \StructType\BaseNniEntityType
     */
    public function setPlaceOfIncorporation($placeOfIncorporation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($placeOfIncorporation) && strlen($placeOfIncorporation) > 30) || (is_array($placeOfIncorporation) && count($placeOfIncorporation) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($placeOfIncorporation) ? strlen($placeOfIncorporation) : count($placeOfIncorporation)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($placeOfIncorporation) && !is_string($placeOfIncorporation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeOfIncorporation)), __LINE__);
        }
        $this->placeOfIncorporation = $placeOfIncorporation;
        return $this;
    }
    /**
     * Get previousStateTerritory value
     * @return \StructType\PreviousStateTerritoryType|null
     */
    public function getPreviousStateTerritory()
    {
        return $this->previousStateTerritory;
    }
    /**
     * Set previousStateTerritory value
     * @param \StructType\PreviousStateTerritoryType $previousStateTerritory
     * @return \StructType\BaseNniEntityType
     */
    public function setPreviousStateTerritory(\StructType\PreviousStateTerritoryType $previousStateTerritory = null)
    {
        $this->previousStateTerritory = $previousStateTerritory;
        return $this;
    }
    /**
     * Get dateRegistered value
     * @return string|null
     */
    public function getDateRegistered()
    {
        return $this->dateRegistered;
    }
    /**
     * Set dateRegistered value
     * @param string $dateRegistered
     * @return \StructType\BaseNniEntityType
     */
    public function setDateRegistered($dateRegistered = null)
    {
        // validation for constraint: minInclusive
        if ($dateRegistered < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRegistered), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRegistered) && !is_string($dateRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRegistered)), __LINE__);
        }
        $this->dateRegistered = $dateRegistered;
        return $this;
    }
    /**
     * Get dateRenewal value
     * @return string|null
     */
    public function getDateRenewal()
    {
        return $this->dateRenewal;
    }
    /**
     * Set dateRenewal value
     * @param string $dateRenewal
     * @return \StructType\BaseNniEntityType
     */
    public function setDateRenewal($dateRenewal = null)
    {
        // validation for constraint: minInclusive
        if ($dateRenewal < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRenewal), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRenewal) && !is_string($dateRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRenewal)), __LINE__);
        }
        $this->dateRenewal = $dateRenewal;
        return $this;
    }
    /**
     * Get dateDeregistered value
     * @return string|null
     */
    public function getDateDeregistered()
    {
        return $this->dateDeregistered;
    }
    /**
     * Set dateDeregistered value
     * @param string $dateDeregistered
     * @return \StructType\BaseNniEntityType
     */
    public function setDateDeregistered($dateDeregistered = null)
    {
        // validation for constraint: minInclusive
        if ($dateDeregistered < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateDeregistered), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDeregistered) && !is_string($dateDeregistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDeregistered)), __LINE__);
        }
        $this->dateDeregistered = $dateDeregistered;
        return $this;
    }
    /**
     * Get dateReview value
     * @return string|null
     */
    public function getDateReview()
    {
        return $this->dateReview;
    }
    /**
     * Set dateReview value
     * @param string $dateReview
     * @return \StructType\BaseNniEntityType
     */
    public function setDateReview($dateReview = null)
    {
        // validation for constraint: minInclusive
        if ($dateReview < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateReview), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateReview) && !is_string($dateReview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateReview)), __LINE__);
        }
        $this->dateReview = $dateReview;
        return $this;
    }
    /**
     * Get jurisdiction value
     * @return string|null
     */
    public function getJurisdiction()
    {
        return $this->jurisdiction;
    }
    /**
     * Set jurisdiction value
     * @param string $jurisdiction
     * @return \StructType\BaseNniEntityType
     */
    public function setJurisdiction($jurisdiction = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($jurisdiction) && strlen($jurisdiction) > 80) || (is_array($jurisdiction) && count($jurisdiction) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($jurisdiction) ? strlen($jurisdiction) : count($jurisdiction)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($jurisdiction) && !is_string($jurisdiction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurisdiction)), __LINE__);
        }
        $this->jurisdiction = $jurisdiction;
        return $this;
    }
    /**
     * Get address value
     * @return string[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $address
     * @return \StructType\BaseNniEntityType
     */
    public function setAddress(array $address = array())
    {
        $invalidValues = array();
        foreach ($address as $baseNniEntityTypeAddressItem) {
            if (!\EnumType\AddressType::valueIsValid($baseNniEntityTypeAddressItem)) {
                $invalidValues[] = var_export($baseNniEntityTypeAddressItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BaseNniEntityType
     */
    public function addToAddress($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get formerName value
     * @return \StructType\FormerName[]|null
     */
    public function getFormerName()
    {
        return $this->formerName;
    }
    /**
     * Set formerName value
     * @throws \InvalidArgumentException
     * @param \StructType\FormerName[] $formerName
     * @return \StructType\BaseNniEntityType
     */
    public function setFormerName(array $formerName = array())
    {
        foreach ($formerName as $baseNniEntityTypeFormerNameItem) {
            // validation for constraint: itemType
            if (!$baseNniEntityTypeFormerNameItem instanceof \StructType\FormerName) {
                throw new \InvalidArgumentException(sprintf('The formerName property can only contain items of \StructType\FormerName, "%s" given', is_object($baseNniEntityTypeFormerNameItem) ? get_class($baseNniEntityTypeFormerNameItem) : gettype($baseNniEntityTypeFormerNameItem)), __LINE__);
            }
        }
        $this->formerName = $formerName;
        return $this;
    }
    /**
     * Add item to formerName value
     * @throws \InvalidArgumentException
     * @param \StructType\FormerName $item
     * @return \StructType\BaseNniEntityType
     */
    public function addToFormerName(\StructType\FormerName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FormerName) {
            throw new \InvalidArgumentException(sprintf('The formerName property can only contain items of \StructType\FormerName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->formerName[] = $item;
        return $this;
    }
    /**
     * Get recentDocument value
     * @return \StructType\DocumentType[]|null
     */
    public function getRecentDocument()
    {
        return $this->recentDocument;
    }
    /**
     * Set recentDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType[] $recentDocument
     * @return \StructType\BaseNniEntityType
     */
    public function setRecentDocument(array $recentDocument = array())
    {
        foreach ($recentDocument as $baseNniEntityTypeRecentDocumentItem) {
            // validation for constraint: itemType
            if (!$baseNniEntityTypeRecentDocumentItem instanceof \StructType\DocumentType) {
                throw new \InvalidArgumentException(sprintf('The recentDocument property can only contain items of \StructType\DocumentType, "%s" given', is_object($baseNniEntityTypeRecentDocumentItem) ? get_class($baseNniEntityTypeRecentDocumentItem) : gettype($baseNniEntityTypeRecentDocumentItem)), __LINE__);
            }
        }
        $this->recentDocument = $recentDocument;
        return $this;
    }
    /**
     * Add item to recentDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType $item
     * @return \StructType\BaseNniEntityType
     */
    public function addToRecentDocument(\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The recentDocument property can only contain items of \StructType\DocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->recentDocument[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseNniEntityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
