<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for attachmentsType StructType
 * @subpackage Structs
 */
class AttachmentsType extends AbstractStructBase
{
    /**
     * The attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\AttachmentType[]
     */
    public $attachment;
    /**
     * Constructor method for attachmentsType
     * @uses AttachmentsType::setAttachment()
     * @param \StructType\AttachmentType[] $attachment
     */
    public function __construct(array $attachment = array())
    {
        $this
            ->setAttachment($attachment);
    }
    /**
     * Get attachment value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachment
     * @return \StructType\AttachmentsType
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $attachmentsTypeAttachmentItem) {
            // validation for constraint: itemType
            if (!$attachmentsTypeAttachmentItem instanceof \StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \StructType\AttachmentType, "%s" given', is_object($attachmentsTypeAttachmentItem) ? get_class($attachmentsTypeAttachmentItem) : gettype($attachmentsTypeAttachmentItem)), __LINE__);
            }
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\AttachmentsType
     */
    public function addToAttachment(\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachmentsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
