<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associateLodgeType StructType
 * @subpackage Structs
 */
class AssociateLodgeType extends AbstractStructBase
{
    /**
     * The abrEntity
     * Meta informations extracted from the WSDL
     * - documentation: Joint Ventures only
     * - minOccurs: 0
     * @var \StructType\AbrEntityType
     */
    public $abrEntity;
    /**
     * The individual
     * Meta informations extracted from the WSDL
     * - documentation: Sole TraderIndividual
     * @var \StructType\IndividualLodgeType
     */
    public $individual;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - documentation: CompanyPartnershipUnincorporateStructure
     * @var \StructType\OrganisationLodgeType
     */
    public $organisation;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $endDate;
    /**
     * The partnerAssociate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\PartnerAssociateLodgeType[]
     */
    public $partnerAssociate;
    /**
     * Constructor method for associateLodgeType
     * @uses AssociateLodgeType::setAbrEntity()
     * @uses AssociateLodgeType::setIndividual()
     * @uses AssociateLodgeType::setOrganisation()
     * @uses AssociateLodgeType::setStartDate()
     * @uses AssociateLodgeType::setEndDate()
     * @uses AssociateLodgeType::setPartnerAssociate()
     * @param \StructType\AbrEntityType $abrEntity
     * @param \StructType\IndividualLodgeType $individual
     * @param \StructType\OrganisationLodgeType $organisation
     * @param string $startDate
     * @param string $endDate
     * @param \StructType\PartnerAssociateLodgeType[] $partnerAssociate
     */
    public function __construct(\StructType\AbrEntityType $abrEntity = null, \StructType\IndividualLodgeType $individual = null, \StructType\OrganisationLodgeType $organisation = null, $startDate = null, $endDate = null, array $partnerAssociate = array())
    {
        $this
            ->setAbrEntity($abrEntity)
            ->setIndividual($individual)
            ->setOrganisation($organisation)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setPartnerAssociate($partnerAssociate);
    }
    /**
     * Get abrEntity value
     * @return \StructType\AbrEntityType|null
     */
    public function getAbrEntity()
    {
        return $this->abrEntity;
    }
    /**
     * Set abrEntity value
     * @param \StructType\AbrEntityType $abrEntity
     * @return \StructType\AssociateLodgeType
     */
    public function setAbrEntity(\StructType\AbrEntityType $abrEntity = null)
    {
        $this->abrEntity = $abrEntity;
        return $this;
    }
    /**
     * Get individual value
     * @return \StructType\IndividualLodgeType|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\IndividualLodgeType $individual
     * @return \StructType\AssociateLodgeType
     */
    public function setIndividual(\StructType\IndividualLodgeType $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\OrganisationLodgeType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\OrganisationLodgeType $organisation
     * @return \StructType\AssociateLodgeType
     */
    public function setOrganisation(\StructType\OrganisationLodgeType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\AssociateLodgeType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: minInclusive
        if ($startDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\AssociateLodgeType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: minInclusive
        if ($endDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get partnerAssociate value
     * @return \StructType\PartnerAssociateLodgeType[]|null
     */
    public function getPartnerAssociate()
    {
        return $this->partnerAssociate;
    }
    /**
     * Set partnerAssociate value
     * @throws \InvalidArgumentException
     * @param \StructType\PartnerAssociateLodgeType[] $partnerAssociate
     * @return \StructType\AssociateLodgeType
     */
    public function setPartnerAssociate(array $partnerAssociate = array())
    {
        foreach ($partnerAssociate as $associateLodgeTypePartnerAssociateItem) {
            // validation for constraint: itemType
            if (!$associateLodgeTypePartnerAssociateItem instanceof \StructType\PartnerAssociateLodgeType) {
                throw new \InvalidArgumentException(sprintf('The partnerAssociate property can only contain items of \StructType\PartnerAssociateLodgeType, "%s" given', is_object($associateLodgeTypePartnerAssociateItem) ? get_class($associateLodgeTypePartnerAssociateItem) : gettype($associateLodgeTypePartnerAssociateItem)), __LINE__);
            }
        }
        $this->partnerAssociate = $partnerAssociate;
        return $this;
    }
    /**
     * Add item to partnerAssociate value
     * @throws \InvalidArgumentException
     * @param \StructType\PartnerAssociateLodgeType $item
     * @return \StructType\AssociateLodgeType
     */
    public function addToPartnerAssociate(\StructType\PartnerAssociateLodgeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartnerAssociateLodgeType) {
            throw new \InvalidArgumentException(sprintf('The partnerAssociate property can only contain items of \StructType\PartnerAssociateLodgeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->partnerAssociate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssociateLodgeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
